/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.BrowserConnection;

public abstract class VmConnection<T extends Vm>
implements Disposable,
BrowserConnection {
    private final AtomicReference<ConnectionState> state = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
    private final EventDispatcher<DebugEventListener> dispatcher = EventDispatcher.create(DebugEventListener.class);
    private final EventDispatcher<SocketConnectionListener> connectionDispatcher = EventDispatcher.create(SocketConnectionListener.class);
    protected volatile T vm;
    private final ActionCallback started = new ActionCallback();
    private final AtomicBoolean closed = new AtomicBoolean();

    public final Vm getVm() {
        return this.vm;
    }

    @Override
    @NotNull
    public ConnectionState getState() {
        ConnectionState connectionState = this.state.get();
        if (connectionState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/connection/VmConnection", "getState"));
        }
        return connectionState;
    }

    public void addDebugListener(@NotNull DebugEventListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/connection/VmConnection", "addDebugListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/connection/VmConnection", "addDebugListener"));
        }
        this.dispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @Override
    public void executeOnStart(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/connection/VmConnection", "executeOnStart"));
        }
        this.started.doWhenDone(runnable);
    }

    protected void setState(@NotNull ConnectionStatus status, @Nullable String message) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/connection/VmConnection", "setState"));
        }
        this.setState(status, message, null);
    }

    protected void setState(@NotNull ConnectionStatus status, @Nullable String message, @Nullable HyperlinkListener messageLinkListener) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/connection/VmConnection", "setState"));
        }
        ConnectionState oldState = this.state.getAndSet(new ConnectionState(status, message, messageLinkListener));
        if (oldState == null || oldState.getStatus() != status) {
            ((SocketConnectionListener)this.connectionDispatcher.getMulticaster()).statusChanged(status);
        }
    }

    @Override
    public void addListener(@NotNull SocketConnectionListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/connection/VmConnection", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/connection/VmConnection", "addListener"));
        }
        this.connectionDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public DebugEventListener getDebugEventListener() {
        return (DebugEventListener)this.dispatcher.getMulticaster();
    }

    protected void startProcessing() {
        this.started.setDone();
    }

    public final void close(@Nullable String message) {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.vm = null;
        if (!this.started.isProcessed()) {
            this.started.setRejected();
        }
        this.setState(ConnectionStatus.DISCONNECTED, message);
        Disposer.dispose((Disposable)this, (boolean)false);
    }

    public void dispose() {
    }

    public ActionCallback detachAndClose() {
        ActionCallback.Done callback;
        T currentVm;
        if (!this.started.isProcessed()) {
            this.started.setRejected();
        }
        if ((currentVm = this.vm) == null) {
            callback = new ActionCallback.Done();
        } else {
            this.vm = null;
            callback = currentVm.detach();
        }
        this.close(null);
        return callback;
    }
}

