/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Consumer;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;

public abstract class ProcessBackedVmConnection
extends VmConnection<Vm> {
    private final AtomicReference<Runnable> connectCancelHandler = new AtomicReference();

    @Override
    @Nullable
    public WebBrowser getBrowser() {
        return null;
    }

    public abstract void createVmAndConnect(@NotNull InetSocketAddress var1, @NotNull AsyncResult<Vm> var2);

    public void open(final @NotNull InetSocketAddress address) {
        if (address == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/connection/ProcessBackedVmConnection", "open"));
        }
        this.setState(ConnectionStatus.WAITING_FOR_CONNECTION, "Connecting to " + address.getHostName() + ":" + address.getPort());
        final Future future = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (Thread.interrupted()) {
                    return;
                }
                final AsyncResult result = new AsyncResult();
                ProcessBackedVmConnection.this.connectCancelHandler.set(new Runnable(){

                    @Override
                    public void run() {
                        result.reject("Closed explicitly");
                    }
                });
                ProcessBackedVmConnection.this.createVmAndConnect(address, (AsyncResult<Vm>)result);
                result.doWhenDone((Consumer)new Consumer<Vm>(){

                    public void consume(@NotNull Vm vm) {
                        if (vm == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/connection/ProcessBackedVmConnection$1$4", "consume"));
                        }
                        ProcessBackedVmConnection.this.vm = vm;
                        ProcessBackedVmConnection.this.setState(ConnectionStatus.CONNECTED, "Connected to " + address.getHostName() + ":" + address.getPort());
                        ProcessBackedVmConnection.this.startProcessing();
                    }
                }).doWhenRejected((Consumer)new Consumer<String>(){

                    public void consume(String error) {
                        if (ProcessBackedVmConnection.this.getState().getStatus() == ConnectionStatus.WAITING_FOR_CONNECTION) {
                            ProcessBackedVmConnection.this.setState(ConnectionStatus.CONNECTION_FAILED, error == null ? "Internal error" : error);
                        }
                    }
                }).doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        ProcessBackedVmConnection.this.connectCancelHandler.set(null);
                    }
                });
            }
        });
        this.connectCancelHandler.set(new Runnable(){

            @Override
            public void run() {
                future.cancel(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionCallback detachAndClose() {
        ActionCallback callback;
        try {
            Runnable runnable = this.connectCancelHandler.getAndSet(null);
            if (runnable != null) {
                runnable.run();
            }
        }
        finally {
            callback = super.detachAndClose();
        }
        return callback;
    }
}

