/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.ObsolescentAsyncResults;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueCallback;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.FunctionScopesValueGroup;
import org.jetbrains.debugger.LazyVariablesGroup;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ObjectValuePresentation;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Variables;
import org.jetbrains.debugger.VariablesGroup;
import org.jetbrains.debugger.values.ArrayValue;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

public final class VariableView
extends XNamedValue
implements VariableContext {
    private static final Pattern ARRAY_DESCRIPTION_PATTERN = Pattern.compile("^[a-zA-Z]+\\[\\d+\\]$");
    private final VariableContext context;
    private final Variable variable;
    private volatile Value value;
    private volatile List<Variable> remainingChildren;
    private volatile int remainingChildrenOffset;

    public VariableView(@NotNull Variable variable, @NotNull VariableContext context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/VariableView", "<init>"));
        }
        super(context.getMemberFilter().normalizeMemberName(variable));
        this.context = context;
        this.variable = variable;
    }

    @NotNull
    public static String getClassName(@NotNull ObjectValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "getClassName"));
        }
        String className = value.getClassName();
        String string = StringUtil.isEmpty((String)className) ? "Object" : className;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getClassName"));
        }
        return string;
    }

    @NotNull
    public static String getObjectValueDescription(@NotNull ObjectValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "getObjectValueDescription"));
        }
        String description = value.getValueString();
        String string = StringUtil.isEmpty((String)description) ? VariableView.getClassName(value) : description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getObjectValueDescription"));
        }
        return string;
    }

    public static void setObjectPresentation(@NotNull ObjectValue value, @NotNull Icon icon, @NotNull XValueNode node) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "setObjectPresentation"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/VariableView", "setObjectPresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/VariableView", "setObjectPresentation"));
        }
        node.setPresentation(icon, (XValuePresentation)new ObjectValuePresentation(VariableView.getObjectValueDescription(value)), value.hasProperties() != ThreeState.NO);
    }

    public static void setArrayPresentation(@NotNull Value value, @NotNull VariableContext context, final @NotNull Icon icon, @NotNull XValueNode node) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "setArrayPresentation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/VariableView", "setArrayPresentation"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/VariableView", "setArrayPresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/VariableView", "setArrayPresentation"));
        }
        assert (value.getType() == ValueType.ARRAY);
        if (value instanceof ArrayValue) {
            int length = ((ArrayValue)value).getLength();
            node.setPresentation(icon, (XValuePresentation)new ArrayPresentation(length), length > 0);
            return;
        }
        String valueString = value.getValueString();
        if (valueString != null && valueString.endsWith("]") && ARRAY_DESCRIPTION_PATTERN.matcher(valueString).find()) {
            node.setPresentation(icon, null, valueString, true);
        } else {
            ObsolescentAsyncResults.consume(context.getEvaluateContext().evaluate("a.length", Collections.singletonMap("a", value)), (Obsolescent)node, (PairConsumer)new PairConsumer<Value, XValueNode>(){

                public void consume(Value lengthValue, XValueNode node) {
                    node.setPresentation(icon, null, "Array[" + lengthValue.getValueString() + ']', true);
                }
            });
        }
    }

    @NotNull
    public static Icon getIcon(@NotNull Value value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "getIcon"));
        }
        ValueType type = value.getType();
        switch (type) {
            case FUNCTION: {
                Icon icon = AllIcons.Nodes.Function;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getIcon"));
                }
                return icon;
            }
            case ARRAY: {
                Icon icon = AllIcons.Debugger.Db_array;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getIcon"));
                }
                return icon;
            }
        }
        Icon icon = type.isObjectType() ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getIcon"));
        }
        return icon;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.context.watchableAsEvaluationExpression();
    }

    @Override
    @NotNull
    public DebuggerViewSupport getDebugProcess() {
        DebuggerViewSupport debuggerViewSupport = this.context.getDebugProcess();
        if (debuggerViewSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getDebugProcess"));
        }
        return debuggerViewSupport;
    }

    @Override
    @Nullable
    public VariableContext getParent() {
        return this.context;
    }

    @Override
    @NotNull
    public MemberFilter getMemberFilter() {
        MemberFilter memberFilter = this.context.getMemberFilter();
        if (memberFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getMemberFilter"));
        }
        return memberFilter;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/VariableView", "computePresentation"));
        }
        this.value = this.variable.getValue();
        if (this.value == null) {
            ObjectValue host = (ObjectValue)((VariableView)this.context).getValue();
            assert (host != null);
            ObsolescentAsyncResults.consume(((ObjectProperty)this.variable).evaluateGet(host, this.getEvaluateContext()), (Obsolescent)node, (PairConsumer)new PairConsumer<Value, XValueNode>(){

                public void consume(Value value, XValueNode node) {
                    VariableView.this.value = value;
                    VariableView.this.computePresentation(value, node);
                }
            });
        } else {
            this.computePresentation(this.value, node);
        }
    }

    @NotNull
    static String trimFunctionDescription(@NotNull Value value) {
        int endIndex;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "trimFunctionDescription"));
        }
        String presentableValue = value.getValueString();
        if (presentableValue == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "trimFunctionDescription"));
            }
            return "";
        }
        for (endIndex = 0; endIndex < presentableValue.length() && !StringUtil.isLineBreak((char)presentableValue.charAt(endIndex)); ++endIndex) {
        }
        while (endIndex > 0 && Character.isWhitespace(presentableValue.charAt(endIndex - 1))) {
            --endIndex;
        }
        String string = presentableValue.substring(0, endIndex);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "trimFunctionDescription"));
        }
        return string;
    }

    private void computePresentation(@NotNull Value value, @NotNull XValueNode node) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "computePresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/VariableView", "computePresentation"));
        }
        String valueString = value.getValueString();
        switch (value.getType()) {
            case OBJECT: 
            case NODE: {
                this.context.getDebugProcess().computeObjectPresentation((ObjectValue)value, this.variable, this.context, node, this.getIcon());
                break;
            }
            case FUNCTION: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new ObjectValuePresentation(VariableView.trimFunctionDescription(value)), true);
                break;
            }
            case ARRAY: {
                this.context.getDebugProcess().computeArrayPresentation(value, this.variable, this.context, node, this.getIcon());
                break;
            }
            case BOOLEAN: 
            case NULL: 
            case UNDEFINED: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new XKeywordValuePresentation(valueString), false);
                break;
            }
            case NUMBER: {
                node.setPresentation(this.getIcon(), VariableView.createNumberPresentation(valueString), false);
                break;
            }
            case STRING: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new XStringValuePresentation(valueString), false);
                if ((!(value instanceof StringValue) || !((StringValue)value).isTruncated()) && valueString.length() <= 100) break;
                node.setFullValueEvaluator((XFullValueEvaluator)new MyFullValueEvaluator(value));
                break;
            }
            default: {
                node.setPresentation(this.getIcon(), null, valueString, true);
            }
        }
    }

    private static XValuePresentation createNumberPresentation(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "createNumberPresentation"));
        }
        return value.equals("NaN") || value.equals("Infinity") ? new XKeywordValuePresentation(value) : new XNumericValuePresentation(value);
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "computeChildren"));
        }
        node.setAlreadySorted(true);
        List<Variable> list = this.remainingChildren;
        if (list != null) {
            int to = Math.min(this.remainingChildrenOffset + 100, list.size());
            boolean isLast = to == list.size();
            node.addChildren(Variables.createVariablesList(list, this.remainingChildrenOffset, to, this), isLast);
            if (!isLast) {
                node.tooManyChildren(list.size() - to);
                this.remainingChildrenOffset += 100;
            }
            return;
        }
        boolean hasNamedProperties = this.value instanceof ObjectValue && ((ObjectValue)this.value).hasProperties() != ThreeState.NO;
        boolean hasIndexedProperties = this.value instanceof ArrayValue;
        ActionCallback.Chunk chunk = new ActionCallback.Chunk();
        if (hasIndexedProperties) {
            chunk.add(this.computeIndexedProperties((ArrayValue)this.value, node, !hasNamedProperties));
        }
        if (hasNamedProperties) {
            chunk.add(this.computeNamedProperties((ObjectValue)this.value, node, !hasIndexedProperties));
        }
        if (hasIndexedProperties == hasNamedProperties) {
            chunk.create().doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    if (!node.isObsolete()) {
                        node.addChildren(XValueChildrenList.EMPTY, true);
                    }
                }
            });
        }
    }

    private ActionCallback computeIndexedProperties(final @NotNull ArrayValue value, @NotNull XCompositeNode node, final boolean isLastChildren) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "computeIndexedProperties"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/VariableView", "computeIndexedProperties"));
        }
        return value.getVariables(0, value.getLength(), 100, new ObsolescentIndexedVariablesConsumer(node){

            @Override
            public void consumeRanges(@Nullable int[] ranges) {
                if (ranges == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroup.addGroups(value, LazyVariablesGroup.GROUP_FACTORY, groupList, 0, value.getLength(), 100, VariableView.this);
                    this.node.addChildren(groupList, isLastChildren);
                } else {
                    LazyVariablesGroup.addRanges(value, ranges, this.node, VariableView.this, isLastChildren);
                }
            }

            @Override
            public void consumeVariables(@NotNull List<Variable> variables) {
                if (variables == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView$4", "consumeVariables"));
                }
                this.node.addChildren(Variables.createVariablesList(variables, VariableView.this), isLastChildren);
            }
        });
    }

    private ActionCallback computeNamedProperties(final @NotNull ObjectValue value, @NotNull XCompositeNode node, final boolean isLastChildren) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "computeNamedProperties"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/VariableView", "computeNamedProperties"));
        }
        return ObsolescentAsyncResults.consume(value.getProperties(), (Obsolescent)node, (PairConsumer)new PairConsumer<List<Variable>, XCompositeNode>(){

            public void consume(List<Variable> variables, XCompositeNode node) {
                FunctionValue functionValue;
                if (value.getType() == ValueType.ARRAY && !(value instanceof ArrayValue)) {
                    VariableView.this.computeArrayRanges(variables, node);
                    return;
                }
                FunctionValue functionValue2 = functionValue = value instanceof FunctionValue ? (FunctionValue)value : null;
                if (functionValue != null && functionValue.hasScopes() == ThreeState.NO) {
                    functionValue = null;
                }
                VariableView.this.remainingChildren = Variables.sortFilterAndAddValueList(variables, node, VariableView.this, 100, functionValue == null);
                if (VariableView.this.remainingChildren != null) {
                    VariableView.this.remainingChildrenOffset = 100;
                }
                if (functionValue != null) {
                    node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new FunctionScopesValueGroup(functionValue, VariableView.this.context)), isLastChildren);
                }
            }
        });
    }

    private void computeArrayRanges(@NotNull List<? extends Variable> properties, @NotNull XCompositeNode node) {
        int notGroupedVariablesOffset;
        int bucketSize;
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "computeArrayRanges"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/VariableView", "computeArrayRanges"));
        }
        List<Variable> variables = Variables.filterAndSort(properties, this, false);
        int count = variables.size();
        if (count <= (bucketSize = 100)) {
            node.addChildren(Variables.createVariablesList(variables, this), true);
            return;
        }
        while (count > 0 && !Character.isDigit(variables.get(count - 1).getName().charAt(0))) {
            --count;
        }
        XValueChildrenList groupList = new XValueChildrenList();
        if (count > 0) {
            LazyVariablesGroup.addGroups(variables, VariablesGroup.GROUP_FACTORY, groupList, 0, count, bucketSize, this);
        }
        if (variables.size() - count > bucketSize) {
            for (notGroupedVariablesOffset = variables.size(); notGroupedVariablesOffset > 0 && variables.get(notGroupedVariablesOffset - 1).getName().startsWith("__"); --notGroupedVariablesOffset) {
            }
            if (notGroupedVariablesOffset > 0) {
                LazyVariablesGroup.addGroups(variables, VariablesGroup.GROUP_FACTORY, groupList, count, notGroupedVariablesOffset, bucketSize, this);
            }
        } else {
            notGroupedVariablesOffset = count;
        }
        for (int i = notGroupedVariablesOffset; i < variables.size(); ++i) {
            groupList.add((XNamedValue)new VariableView(variables.get(i), this));
        }
        node.addChildren(groupList, true);
    }

    @NotNull
    private Icon getIcon() {
        Icon icon = VariableView.getIcon(this.value);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public XValueModifier getModifier() {
        if (!this.variable.isMutable()) {
            return null;
        }
        return new XValueModifier(){

            public String getInitialValueEditorText() {
                if (VariableView.this.value.getType() == ValueType.STRING) {
                    String string = VariableView.this.value.getValueString();
                    StringBuilder builder = new StringBuilder(string.length());
                    builder.append('\"');
                    StringUtil.escapeStringCharacters((int)string.length(), (String)string, (StringBuilder)builder);
                    builder.append('\"');
                    return builder.toString();
                }
                return VariableView.this.value.getType().isObjectType() ? null : VariableView.this.value.getValueString();
            }

            public void setValue(@NotNull String expression, final @NotNull XValueModifier.XModificationCallback callback) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView$6", "setValue"));
                }
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/VariableView$6", "setValue"));
                }
                ValueModifier valueModifier = VariableView.this.variable.getValueModifier();
                assert (valueModifier != null);
                valueModifier.setValue(VariableView.this.variable, expression, VariableView.this.getEvaluateContext()).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        VariableView.this.value = null;
                        callback.valueModified();
                    }
                }).doWhenRejected(VariableView.createErrorMessageConsumer((XValueCallback)callback));
            }
        };
    }

    private static Consumer<String> createErrorMessageConsumer(final @NotNull XValueCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "createErrorMessageConsumer"));
        }
        return new Consumer<String>(){

            public void consume(@Nullable String errorMessage) {
                callback.errorOccurred(errorMessage == null ? "Internal error" : errorMessage);
            }
        };
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        EvaluateContext evaluateContext = this.context.getEvaluateContext();
        if (evaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getEvaluateContext"));
        }
        return evaluateContext;
    }

    @Nullable
    public Value getValue() {
        return this.variable.getValue();
    }

    public boolean canNavigateToSource() {
        return this.value instanceof FunctionValue || this.getDebugProcess().canNavigateToSource(this.variable, this.context);
    }

    public void computeSourcePosition(final @NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView", "computeSourcePosition"));
        }
        if (this.value instanceof FunctionValue) {
            ((FunctionValue)this.value).resolve().doWhenDone((Consumer)new Consumer<FunctionValue>(){

                public void consume(final FunctionValue function) {
                    VariableView.this.getDebugProcess().getVm().getScriptManager().getScript(function).doWhenDone((Consumer)new Consumer<Script>(){

                        public void consume(Script script) {
                            navigatable.setSourcePosition(script == null ? null : VariableView.this.getDebugProcess().getSourceInfo(null, script, function.getOpenParenLine(), function.getOpenParenColumn()));
                        }
                    });
                }
            });
        } else {
            this.getDebugProcess().computeSourcePosition(this.variable, this.context, navigatable);
        }
    }

    @Nullable
    public String getEvaluationExpression() {
        if (!this.watchableAsEvaluationExpression()) {
            return null;
        }
        SmartList list = new SmartList((Object)this.variable.getName());
        for (VariableContext parent = this.context; parent != null && parent.getName() != null; parent = parent.getParent()) {
            list.add((Object)parent.getName());
        }
        return this.context.getDebugProcess().propertyNamesToString((List<String>)list, false);
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.context.getScope();
    }

    private static class MyFullValueEvaluator
    extends XFullValueEvaluator {
        private final Value value;

        public MyFullValueEvaluator(@NotNull Value value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView$MyFullValueEvaluator", "<init>"));
            }
            super(value instanceof StringValue ? ((StringValue)value).getLength() : value.getValueString().length());
            this.value = value;
        }

        public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView$MyFullValueEvaluator", "startEvaluation"));
            }
            if (!(this.value instanceof StringValue) || !((StringValue)this.value).isTruncated()) {
                callback.evaluated(this.value.getValueString());
                return;
            }
            final AtomicBoolean evaluated = new AtomicBoolean();
            ((StringValue)this.value).getFullString().doWhenDone(new Runnable(){

                @Override
                public void run() {
                    if (!callback.isObsolete() && evaluated.compareAndSet(false, true)) {
                        callback.evaluated(MyFullValueEvaluator.this.value.getValueString());
                    }
                }
            }).doWhenRejected(VariableView.createErrorMessageConsumer((XValueCallback)callback));
        }
    }

    public static abstract class ObsolescentIndexedVariablesConsumer
    extends ArrayValue.IndexedVariablesConsumer {
        protected final XCompositeNode node;

        protected ObsolescentIndexedVariablesConsumer(@NotNull XCompositeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView$ObsolescentIndexedVariablesConsumer", "<init>"));
            }
            this.node = node;
        }

        @Override
        public boolean isObsolete() {
            return this.node.isObsolete();
        }
    }

    private static final class ArrayPresentation
    extends XValuePresentation {
        private final String length;

        private ArrayPresentation(int length) {
            this.length = Integer.toString(length);
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VariableView$ArrayPresentation", "renderValue"));
            }
            renderer.renderSpecialSymbol("Array[");
            renderer.renderSpecialSymbol(this.length);
            renderer.renderSpecialSymbol("]");
        }
    }
}

