/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextAdditionalParameter;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.Value;

public final class ValueModifierUtil {
    private static final Pattern KEY_NOTATION_PROPERTY_NAME_PATTERN = Pattern.compile("[\\p{L}_$]+[\\d\\p{L}_$]*");
    private static final String[] REPLACEMENT_CHARS = new String[128];

    public static ActionCallback setValue(final @NotNull Variable variable, String newValue, final @NotNull EvaluateContext evaluateContext, final @NotNull ValueModifier modifier) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        final ActionCallback callback = new ActionCallback();
        evaluateContext.evaluate(newValue).doWhenDone((Consumer)new Consumer<Value>(){

            public void consume(Value value) {
                modifier.setValue(variable, value, evaluateContext).notify(callback);
            }
        }).notifyWhenRejected(callback);
        return callback;
    }

    @NotNull
    public static AsyncResult<Value> evaluateGet(final @NotNull ObjectProperty property, @NotNull EvaluateContextAdditionalParameter host, @NotNull EvaluateContext evaluateContext, @NotNull String selfName) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        if (selfName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        FunctionValue getterFunction = property.getGetter();
        if (getterFunction == null) {
            throw new RuntimeException("Getter is not a function");
        }
        StringBuilder builder = new StringBuilder(selfName);
        ValueModifierUtil.appendName(builder, property.getName(), false);
        AsyncResult asyncResult = evaluateContext.evaluate(builder.toString(), Collections.singletonMap(selfName, host)).doWhenDone((Consumer)new Consumer<Value>(){

            public void consume(Value value) {
                property.setValue(value);
            }
        });
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        return asyncResult;
    }

    public static String propertyNamesToString(List<String> list, boolean quotedAware) {
        StringBuilder builder = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            String name = list.get(i);
            boolean quoted = quotedAware && (name.charAt(0) == '\"' || name.charAt(0) == '\'');
            ValueModifierUtil.appendName(builder, name, quoted);
        }
        return builder.toString();
    }

    public static void appendName(@NotNull StringBuilder builder, @NotNull String name, boolean quoted) {
        boolean useKeyNotation;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ValueModifierUtil", "appendName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/ValueModifierUtil", "appendName"));
        }
        boolean bl = useKeyNotation = !quoted && KEY_NOTATION_PROPERTY_NAME_PATTERN.matcher(name).matches();
        if (builder.length() != 0) {
            builder.append(useKeyNotation ? (char)'.' : '[');
        }
        if (useKeyNotation) {
            builder.append(name);
        } else {
            if (quoted) {
                builder.append(name);
            } else {
                ValueModifierUtil.escape(name, builder);
            }
            builder.append(']');
        }
    }

    public static void escape(CharSequence value, StringBuilder sb) {
        int length = value.length();
        sb.ensureCapacity(sb.capacity() + length + 2);
        sb.append('\"');
        int last = 0;
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                sb.append(value, last, i);
            }
            sb.append(replacement);
            last = i + 1;
        }
        if (last < length) {
            sb.append(value, last, length);
        }
        sb.append('\"');
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            ValueModifierUtil.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        ValueModifierUtil.REPLACEMENT_CHARS[34] = "\\\"";
        ValueModifierUtil.REPLACEMENT_CHARS[92] = "\\\\";
        ValueModifierUtil.REPLACEMENT_CHARS[9] = "\\t";
        ValueModifierUtil.REPLACEMENT_CHARS[8] = "\\b";
        ValueModifierUtil.REPLACEMENT_CHARS[10] = "\\n";
        ValueModifierUtil.REPLACEMENT_CHARS[13] = "\\r";
        ValueModifierUtil.REPLACEMENT_CHARS[12] = "\\f";
    }
}

