/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.debugger.SuspendContextManager;

public abstract class SuspendContextManagerBase<T extends SuspendContextBase, CALL_FRAME extends CallFrame>
implements SuspendContextManager<CALL_FRAME> {
    protected final AtomicReference<T> context = new AtomicReference();
    protected final AtomicReference<ActionCallback> suspendCallback = new AtomicReference();

    public final void setContext(T newContext) {
        if (!this.context.compareAndSet(null, newContext)) {
            throw new IllegalStateException("Attempt to set context, but current suspend context is already exists");
        }
    }

    public final void contextDismissed(T context, @NotNull DebugEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/SuspendContextManagerBase", "contextDismissed"));
        }
        if (!this.context.compareAndSet(context, null)) {
            throw new IllegalStateException("Expected " + context + ", but another suspend context exists");
        }
        listener.resumed();
    }

    @Nullable
    public final T getContext() {
        return (T)((SuspendContextBase)this.context.get());
    }

    @NotNull
    public T getContextOrFail() {
        SuspendContext context = this.getContext();
        if (context == null) {
            throw new IllegalStateException("No current suspend context");
        }
        SuspendContext suspendContext = context;
        if (suspendContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "getContextOrFail"));
        }
        return (T)suspendContext;
    }

    @Override
    @NotNull
    public final ActionCallback suspend() {
        ActionCallback callback = this.suspendCallback.get();
        if (callback != null) {
            ActionCallback actionCallback = callback;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "suspend"));
            }
            return actionCallback;
        }
        if (this.context.get() != null) {
            ActionCallback.Done done = new ActionCallback.Done();
            if (done == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "suspend"));
            }
            return done;
        }
        callback = new ActionCallback();
        this.doSuspend(callback).notifyWhenRejected(callback);
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "suspend"));
        }
        return actionCallback;
    }

    protected abstract ActionCallback doSuspend(ActionCallback var1);

    @Override
    public boolean isContextObsolete(@NotNull SuspendContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/SuspendContextManagerBase", "isContextObsolete"));
        }
        return this.context.get() != context;
    }

    @Override
    public void setOverlayMessage(@Nullable String message) {
    }

    @Override
    @NotNull
    public final AsyncResult<Boolean> restartFrame(@NotNull CALL_FRAME callFrame) {
        if (callFrame == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/SuspendContextManagerBase", "restartFrame"));
        }
        AsyncResult<Boolean> asyncResult = this.restartFrame(callFrame, this.getContextOrFail());
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "restartFrame"));
        }
        return asyncResult;
    }

    @NotNull
    protected abstract AsyncResult<Boolean> restartFrame(@NotNull CALL_FRAME var1, @NotNull T var2);
}

