/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;

public abstract class ContextDependentAsyncResultConsumer<T>
implements Consumer<T> {
    protected final SuspendContext context;

    public ContextDependentAsyncResultConsumer(@NotNull SuspendContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ContextDependentAsyncResultConsumer", "<init>"));
        }
        this.context = context;
    }

    public final void consume(T result) {
        Vm vm = this.context.getVm();
        if (vm.isAttached() && !vm.getSuspendContextManager().isContextObsolete(this.context)) {
            this.consume(result, vm);
        }
    }

    protected abstract void consume(T var1, @NotNull Vm var2);
}

