/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.validation.RngParser;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RngSchemaValidator
extends ExternalAnnotator<MyValidationMessageConsumer, MyValidationMessageConsumer> {
    private static final Logger LOG = Logger.getInstance((String)RngSchemaValidator.class.getName());

    @Nullable
    public MyValidationMessageConsumer collectInformation(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/relaxNG/validation/RngSchemaValidator", "collectInformation"));
        }
        FileType type = file.getFileType();
        if (type != StdFileTypes.XML && type != RncFileType.getInstance()) {
            return null;
        }
        XmlFile xmlfile = (XmlFile)file;
        XmlDocument document = xmlfile.getDocument();
        if (document == null) {
            return null;
        }
        if (type == StdFileTypes.XML) {
            XmlTag rootTag = document.getRootTag();
            if (rootTag == null) {
                return null;
            }
            if (!"http://relaxng.org/ns/structure/1.0".equals(rootTag.getNamespace())) {
                return null;
            }
        } else if (!ApplicationManager.getApplication().isUnitTestMode() && MyErrorFinder.hasError((PsiElement)xmlfile)) {
            return null;
        }
        final Document doc = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        final MyValidationMessageConsumer consumer = new MyValidationMessageConsumer();
        DefaultHandler eh = new DefaultHandler(){

            @Override
            public void warning(SAXParseException e) {
                RngSchemaValidator.handleError(e, file, doc, consumer.warning());
            }

            @Override
            public void error(SAXParseException e) {
                RngSchemaValidator.handleError(e, file, doc, consumer.error());
            }
        };
        RngParser.parsePattern(file, eh, true);
        return consumer;
    }

    @Nullable
    public MyValidationMessageConsumer doAnnotate(MyValidationMessageConsumer collectedInfo) {
        return collectedInfo;
    }

    public void apply(@NotNull PsiFile file, MyValidationMessageConsumer annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/relaxNG/validation/RngSchemaValidator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/intellij/plugins/relaxNG/validation/RngSchemaValidator", "apply"));
        }
        annotationResult.apply(holder);
    }

    public static void handleError(SAXParseException ex, PsiFile file, Document document, ValidationMessageConsumer consumer) {
        PsiElement at;
        VirtualFile virtualFile;
        String systemId = ex.getSystemId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("RNG Schema error: " + ex.getMessage() + " [" + systemId + "]");
        }
        if (systemId != null && !Comparing.equal((Object)(virtualFile = RngSchemaValidator.findVirtualFile(systemId)), (Object)file.getVirtualFile())) {
            return;
        }
        int line = ex.getLineNumber();
        if (line > 0) {
            PsiElement e;
            int column = ex.getColumnNumber();
            int startOffset = document.getLineStartOffset(line - 1);
            at = column > 0 ? (file.getFileType() == RncFileType.getInstance() ? ((e = file.findElementAt(startOffset + column)) == null ? e : file.findElementAt(startOffset + column - 1)) : file.findElementAt(startOffset + column - 2)) : ((e = file.findElementAt(startOffset)) != null ? PsiTreeUtil.nextLeaf((PsiElement)e) : null);
        } else {
            XmlDocument d = ((XmlFile)file).getDocument();
            assert (d != null);
            XmlTag rootTag = d.getRootTag();
            assert (rootTag != null);
            at = rootTag.getFirstChild();
        }
        PsiElement host = file instanceof RncFile ? at : PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])new Class[]{XmlAttribute.class, XmlTag.class});
        if (at != null && host != null) {
            consumer.onMessage(host, ex.getMessage());
        } else {
            consumer.onMessage((PsiElement)file, ex.getMessage());
        }
    }

    public static VirtualFile findVirtualFile(String systemId) {
        try {
            return VfsUtil.findFileByURL((URL)new URL(systemId));
        }
        catch (Exception e) {
            LOG.warn("Failed to build file from uri <" + systemId + ">", (Throwable)e);
            return VirtualFileManager.getInstance().findFileByUrl(VfsUtil.fixURLforIDEA((String)systemId));
        }
    }

    private static class MyErrorFinder
    extends PsiRecursiveElementVisitor {
        private static final MyErrorFinder INSTANCE = new MyErrorFinder();
        private static final HasError FOUND = new HasError();

        private MyErrorFinder() {
        }

        public void visitErrorElement(PsiErrorElement element) {
            throw FOUND;
        }

        public static boolean hasError(PsiElement element) {
            try {
                element.accept((PsiElementVisitor)INSTANCE);
                return false;
            }
            catch (HasError e) {
                return true;
            }
        }

        private static final class HasError
        extends RuntimeException {
            private HasError() {
            }
        }
    }

    private static class WarningMessageConsumer
    extends MessageConsumerImpl {
        public WarningMessageConsumer(AnnotationHolder holder) {
            super(holder);
        }

        @Override
        protected void createAnnotation(ASTNode node, String message) {
            this.myHolder.createWarningAnnotation(node, message);
        }
    }

    private static class ErrorMessageConsumer
    extends MessageConsumerImpl {
        @NonNls
        private static final String MISSING_START_ELEMENT = "missing \"start\" element";
        private static final String UNDEFINED_PATTERN = "reference to undefined pattern ";

        public ErrorMessageConsumer(AnnotationHolder holder) {
            super(holder);
        }

        @Override
        protected void createAnnotation(ASTNode node, String message) {
            if (MISSING_START_ELEMENT.equals(message)) {
                PsiFile psiFile = node.getPsi().getContainingFile();
                if (psiFile instanceof XmlFile) {
                    PsiElementProcessor.FindElement processor = new PsiElementProcessor.FindElement();
                    RelaxIncludeIndex.processBackwardDependencies((XmlFile)psiFile, (PsiElementProcessor<XmlFile>)processor);
                    if (processor.isFound()) {
                        this.myHolder.createWeakWarningAnnotation(node, message);
                        return;
                    }
                }
            } else if (message != null && message.startsWith(UNDEFINED_PATTERN)) {
                return;
            }
            this.myHolder.createErrorAnnotation(node, message);
        }
    }

    private static abstract class MessageConsumerImpl
    implements ValidationMessageConsumer {
        protected final AnnotationHolder myHolder;

        public MessageConsumerImpl(AnnotationHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void onMessage(PsiElement host, String message) {
            ASTNode node = host.getNode();
            assert (node != null);
            if (host instanceof XmlAttribute) {
                ASTNode nameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
                this.createAnnotation(nameNode, message);
            } else if (host instanceof XmlTag) {
                ASTNode end;
                ASTNode start = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
                if (start != null) {
                    this.createAnnotation(start, message);
                }
                if ((end = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(node)) != null) {
                    this.createAnnotation(end, message);
                }
            } else {
                this.createAnnotation(node, message);
            }
        }

        protected abstract void createAnnotation(ASTNode var1, String var2);
    }

    public static interface ValidationMessageConsumer {
        public void onMessage(PsiElement var1, String var2);
    }

    static class MyValidationMessageConsumer {
        List<Pair<PsiElement, String>> errors = new ArrayList<Pair<PsiElement, String>>();
        List<Pair<PsiElement, String>> warnings = new ArrayList<Pair<PsiElement, String>>();

        MyValidationMessageConsumer() {
        }

        ValidationMessageConsumer error() {
            return new ValidationMessageConsumer(){

                @Override
                public void onMessage(PsiElement context, String message) {
                    MyValidationMessageConsumer.this.errors.add((Pair<PsiElement, String>)Pair.create((Object)context, (Object)message));
                }
            };
        }

        ValidationMessageConsumer warning() {
            return new ValidationMessageConsumer(){

                @Override
                public void onMessage(PsiElement context, String message) {
                    MyValidationMessageConsumer.this.warnings.add((Pair<PsiElement, String>)Pair.create((Object)context, (Object)message));
                }
            };
        }

        void apply(AnnotationHolder holder) {
            ErrorMessageConsumer errorc = new ErrorMessageConsumer(holder);
            WarningMessageConsumer warningc = new WarningMessageConsumer(holder);
            for (Pair<PsiElement, String> error : this.errors) {
                errorc.onMessage((PsiElement)error.first, (String)error.second);
            }
            for (Pair<PsiElement, String> warning : this.warnings) {
                warningc.onMessage((PsiElement)warning.first, (String)warning.second);
            }
        }
    }
}

