/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import net.n3.nanoxml.IXMLBuilder;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelaxSymbolIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"RelaxSymbolIndex");

    public static Collection<String> getSymbolNames(Project project) {
        return FileBasedIndex.getInstance().getAllKeys(NAME, project);
    }

    public static NavigationItem[] getSymbolsByName(String name, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        SymbolCollector processor = new SymbolCollector(name, project, scope);
        FileBasedIndex.getInstance().processValues(NAME, (Object)name, null, (FileBasedIndex.ValueProcessor)processor, scope);
        return processor.getResult();
    }

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(FileContent inputData) {
                Grammar grammar;
                PsiFile file;
                final HashMap<String, Void> map = new HashMap<String, Void>();
                if (inputData.getFileType() == XmlFileType.INSTANCE) {
                    CharSequence inputDataContentAsText = inputData.getContentAsText();
                    if (CharArrayUtil.indexOf((CharSequence)inputDataContentAsText, (CharSequence)"http://relaxng.org/ns/structure/1.0", (int)0) == -1) {
                        Map<String, Void> map2 = Collections.emptyMap();
                        if (map2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex$1", "map"));
                        }
                        return map2;
                    }
                    NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
                        NanoXmlUtil.IXMLBuilderAdapter attributeHandler;
                        int depth;

                        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                            if (this.attributeHandler != null) {
                                this.attributeHandler.addAttribute(key, nsPrefix, nsURI, value, type);
                            }
                        }

                        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                            this.attributeHandler = null;
                            if (this.depth == 1 && "http://relaxng.org/ns/structure/1.0".equals(nsURI) && "define".equals(name)) {
                                this.attributeHandler = new NanoXmlUtil.IXMLBuilderAdapter(){

                                    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                                        if ("name".equals(key) && (nsURI == null || nsURI.length() == 0) && value != null) {
                                            map.put(value, null);
                                        }
                                    }
                                };
                            }
                            ++this.depth;
                        }

                        public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                            this.attributeHandler = null;
                            --this.depth;
                        }
                    });
                } else if (inputData.getFileType() == RncFileType.getInstance() && (file = inputData.getPsiFile()) instanceof XmlFile && (grammar = GrammarFactory.getGrammar((XmlFile)file)) != null) {
                    grammar.acceptChildren(new CommonElement.Visitor(){

                        @Override
                        public void visitDefine(Define define) {
                            String name = define.getName();
                            if (name != null) {
                                map.put(name, null);
                            }
                        }
                    });
                }
                HashMap<String, Void> hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = new EnumeratorStringDescriptor();
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML, RncFileType.getInstance()}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex$2", "acceptInput"));
                }
                return !(file.getFileSystem() instanceof JarFileSystem);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    private static class MyNavigationItem
    implements PsiElementNavigationItem,
    ItemPresentation {
        private final NavigationItem myItem;
        private final ItemPresentation myPresentation;

        private MyNavigationItem(NavigationItem item, @NotNull ItemPresentation presentation) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/relaxNG/model/resolve/RelaxSymbolIndex$MyNavigationItem", "<init>"));
            }
            this.myItem = item;
            this.myPresentation = presentation;
        }

        public String getPresentableText() {
            return this.myPresentation.getPresentableText();
        }

        @Nullable
        public String getLocationString() {
            return MyNavigationItem.getLocationString((PsiElement)this.myItem);
        }

        private static String getLocationString(PsiElement element) {
            return "(in " + element.getContainingFile().getName() + ")";
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return this.myPresentation.getIcon(open);
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            return this.myPresentation instanceof ColoredItemPresentation ? ((ColoredItemPresentation)this.myPresentation).getTextAttributesKey() : null;
        }

        public String getName() {
            return this.myItem.getName();
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public PsiElement getTargetElement() {
            return (PsiElement)this.myItem;
        }

        public void navigate(boolean requestFocus) {
            this.myItem.navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.myItem.canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.myItem.canNavigateToSource();
        }

        public static void add(final NavigationItem item, Collection<NavigationItem> symbolNavItems) {
            Object presentation;
            if (item instanceof PsiMetaOwner) {
                PsiMetaData data = ((PsiMetaOwner)item).getMetaData();
                if (data instanceof PsiPresentableMetaData) {
                    final PsiPresentableMetaData metaData = (PsiPresentableMetaData)data;
                    presentation = new ColoredItemPresentation(){

                        public String getPresentableText() {
                            return metaData.getName();
                        }

                        @Nullable
                        public String getLocationString() {
                            return MyNavigationItem.getLocationString((PsiElement)item);
                        }

                        @Nullable
                        public Icon getIcon(boolean open) {
                            return metaData.getIcon();
                        }

                        @Nullable
                        public TextAttributesKey getTextAttributesKey() {
                            ItemPresentation p = item.getPresentation();
                            return p instanceof ColoredItemPresentation ? ((ColoredItemPresentation)p).getTextAttributesKey() : null;
                        }
                    };
                } else {
                    presentation = item.getPresentation();
                }
            } else {
                presentation = item.getPresentation();
            }
            if (presentation != null) {
                symbolNavItems.add((NavigationItem)new MyNavigationItem(item, (ItemPresentation)presentation));
            }
        }
    }

    private static class SymbolCollector
    implements FileBasedIndex.ValueProcessor<Void> {
        private final GlobalSearchScope myScope;
        private final PsiManager myMgr;
        private final String myName;
        private final Collection<NavigationItem> myResult = new ArrayList<NavigationItem>();

        public SymbolCollector(String name, Project project, GlobalSearchScope scope) {
            this.myMgr = PsiManager.getInstance((Project)project);
            this.myScope = scope;
            this.myName = name;
        }

        public boolean process(VirtualFile file, Void kind) {
            Grammar grammar;
            PsiFile psiFile;
            if (this.myScope.contains(file) && (psiFile = this.myMgr.findFile(file)) instanceof XmlFile && (grammar = GrammarFactory.getGrammar((XmlFile)psiFile)) != null) {
                grammar.acceptChildren(new CommonElement.Visitor(){

                    @Override
                    public void visitDefine(Define define) {
                        Object psi;
                        if (SymbolCollector.this.myName.equals(define.getName()) && (psi = define.getPsiElement()) != null) {
                            MyNavigationItem.add((NavigationItem)define.getPsiElement(), SymbolCollector.this.myResult);
                        }
                    }
                });
            }
            return true;
        }

        public NavigationItem[] getResult() {
            return this.myResult.toArray(new NavigationItem[this.myResult.size()]);
        }
    }
}

