/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettings;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettingsImpl;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertSchemaDialog
extends DialogWrapper
implements PropertyChangeListener {
    private final ConvertSchemaSettingsImpl mySettings;
    private final AbstractAction myAdvancedAction;

    protected ConvertSchemaDialog(Project project, SchemaType input, VirtualFile firstFile) {
        super(project, false);
        this.setTitle("Convert Schema File");
        this.mySettings = new ConvertSchemaSettingsImpl(project, input, firstFile);
        this.mySettings.addPropertyChangeListener("output-type", this);
        this.mySettings.addPropertyChangeListener("output-path", this);
        this.myAdvancedAction = new AbstractAction("Advanced..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvertSchemaDialog.this.mySettings.showAdvancedSettings();
            }
        };
        this.myAdvancedAction.setEnabled(this.mySettings.hasAdvancedSettings());
        this.init();
        this.getOKAction().setEnabled(this.mySettings.getOutputDestination().trim().length() > 0);
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{this.myAdvancedAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/convert/ConvertSchemaDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySettings.getPreferredFocusedComponent();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.mySettings.getRoot();
    }

    public ConvertSchemaSettings getSettings() {
        return this.mySettings;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("output-type".equals(evt.getPropertyName())) {
            this.myAdvancedAction.setEnabled(this.mySettings.hasAdvancedSettings());
        } else if ("output-path".equals(evt.getPropertyName())) {
            this.getOKAction().setEnabled(((String)evt.getNewValue()).trim().length() > 0);
        }
    }
}

