/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RngCompactLanguage;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncDocument;
import org.jetbrains.annotations.NotNull;

public class RncFileImpl
extends PsiFileBase
implements RncFile,
XmlFile {
    private static final TokenSet DECLS = TokenSet.create((IElementType[])new IElementType[]{RncElementTypes.NS_DECL, RncElementTypes.DATATYPES_DECL});

    public RncFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, RngCompactLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = RncFileType.getInstance();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileImpl", "getFileType"));
        }
        return fileType;
    }

    @NotNull
    public XmlDocument getDocument() {
        XmlDocument document = this.findChildByClass(XmlDocument.class);
        assert (document != null);
        XmlDocument xmlDocument = document;
        if (xmlDocument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileImpl", "getDocument"));
        }
        return xmlDocument;
    }

    public XmlTag getRootTag() {
        return this.getDocument().getRootTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        ASTNode[] nodes;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileImpl", "processDeclarations"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileImpl", "processDeclarations"));
        }
        ASTNode docNode = this.getDocument().getNode();
        assert (docNode != null);
        for (ASTNode node : nodes = docNode.getChildren(DECLS)) {
            if (processor.execute(node.getPsi(), substitutor)) continue;
            return false;
        }
        RncGrammar grammar = this.getGrammar();
        if (grammar == null) return true;
        return grammar.processDeclarations(processor, substitutor, lastParent, place);
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileImpl", "add"));
        }
        return this.getDocument().add(element);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileImpl", "addAfter"));
        }
        return this.getDocument().addAfter(element, anchor);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/relaxNG/compact/psi/impl/RncFileImpl", "addBefore"));
        }
        return this.getDocument().addBefore(element, anchor);
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        return false;
    }

    public GlobalSearchScope getFileResolveScope() {
        return ProjectScope.getAllScope((Project)this.getProject());
    }

    public boolean ignoreReferencedElementAccessibility() {
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getName();
    }

    @Override
    public RncDecl[] getDeclarations() {
        return ((RncDocument)this.getDocument()).findChildrenByClass(RncDecl.class);
    }

    @Override
    public RncGrammar getGrammar() {
        XmlDocument document = this.getDocument();
        return ((RncDocument)document).getGrammar();
    }
}

