/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpQuantifierImpl
extends RegExpElementImpl
implements RegExpQuantifier {
    public RegExpQuantifierImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpQuantifier(this);
    }

    @Override
    @NotNull
    public RegExpAtom getAtom() {
        ASTNode[] nodes = this.getNode().getChildren(RegExpElementTypes.ATOMS);
        assert (nodes.length > 0);
        RegExpAtom regExpAtom = (RegExpAtom)nodes[0].getPsi();
        if (regExpAtom == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getAtom"));
        }
        return regExpAtom;
    }

    @Override
    @NotNull
    public RegExpQuantifier.Count getCount() {
        ASTNode[] nodes = this.getNode().getChildren(RegExpTT.QUANTIFIERS);
        assert (nodes.length > 0);
        IElementType type = nodes[0].getElementType();
        if (type == RegExpTT.QUEST) {
            RegExpQuantifier.SimpleCount simpleCount = RegExpQuantifier.SimpleCount.ONE_OR_ZERO;
            if (simpleCount == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getCount"));
            }
            return simpleCount;
        }
        if (type == RegExpTT.STAR) {
            RegExpQuantifier.SimpleCount simpleCount = RegExpQuantifier.SimpleCount.ZERO_OR_MORE;
            if (simpleCount == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getCount"));
            }
            return simpleCount;
        }
        if (type == RegExpTT.PLUS) {
            RegExpQuantifier.SimpleCount simpleCount = RegExpQuantifier.SimpleCount.ONE_OR_MORE;
            if (simpleCount == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getCount"));
            }
            return simpleCount;
        }
        if (type == RegExpTT.LBRACE) {
            ASTNode[] numbers = this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{RegExpTT.NUMBER}));
            if (numbers.length >= 1) {
                String min = numbers[0].getText();
                String max = numbers.length == 2 ? numbers[1].getText() : (this.getNode().findChildByType(RegExpTT.COMMA) != null ? "" : min);
                RepeatedCount repeatedCount = new RepeatedCount(min, max);
                if (repeatedCount == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getCount"));
                }
                return repeatedCount;
            }
            RepeatedCount repeatedCount = new RepeatedCount("", "");
            if (repeatedCount == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getCount"));
            }
            return repeatedCount;
        }
        assert (false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getCount"));
        }
        return null;
    }

    @Override
    @NotNull
    public RegExpQuantifier.Type getType() {
        ASTNode[] nodes = this.getNode().getChildren(RegExpTT.QUANTIFIERS);
        if (nodes.length > 1) {
            IElementType type = nodes[1].getElementType();
            if (type == RegExpTT.QUEST) {
                RegExpQuantifier.Type type2 = RegExpQuantifier.Type.RELUCTANT;
                if (type2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getType"));
                }
                return type2;
            }
            if (type == RegExpTT.PLUS) {
                RegExpQuantifier.Type type3 = RegExpQuantifier.Type.POSSESSIVE;
                if (type3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getType"));
                }
                return type3;
            }
        }
        RegExpQuantifier.Type type = RegExpQuantifier.Type.GREEDY;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl", "getType"));
        }
        return type;
    }

    private static class RepeatedCount
    implements RegExpQuantifier.Count {
        private final String myMin;
        private final String myMax;

        public RepeatedCount(@NotNull String min, @NotNull String max) {
            if (min == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl$RepeatedCount", "<init>"));
            }
            if (max == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl$RepeatedCount", "<init>"));
            }
            this.myMin = min;
            this.myMax = max;
        }

        @Override
        @NotNull
        public String getMin() {
            String string = this.myMin;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl$RepeatedCount", "getMin"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getMax() {
            String string = this.myMax;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl$RepeatedCount", "getMax"));
            }
            return string;
        }
    }
}

