/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPyNamedGroupRef;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpPyNamedGroupRefImpl
extends RegExpElementImpl
implements RegExpPyNamedGroupRef {
    public RegExpPyNamedGroupRefImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpPyNamedGroupRef(this);
    }

    @Override
    @Nullable
    public RegExpGroup resolve() {
        PsiElementProcessor.FindFilteredElement processor = new PsiElementProcessor.FindFilteredElement(new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                if (element instanceof RegExpGroup && ((RegExpGroup)element).isPythonNamedGroup() && Comparing.equal((String)RegExpPyNamedGroupRefImpl.this.getGroupName(), (String)((RegExpGroup)element).getGroupName())) {
                    return true;
                }
                return element == RegExpPyNamedGroupRefImpl.this;
            }
        });
        PsiTreeUtil.processElements((PsiElement)this.getContainingFile(), (PsiElementProcessor)processor);
        if (processor.getFoundElement() instanceof RegExpGroup) {
            return (RegExpGroup)processor.getFoundElement();
        }
        return null;
    }

    @Override
    @Nullable
    public String getGroupName() {
        ASTNode nameNode = this.getNode().findChildByType(RegExpTT.NAME);
        return nameNode != null ? nameNode.getText() : null;
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            public PsiElement getElement() {
                return RegExpPyNamedGroupRefImpl.this;
            }

            public TextRange getRangeInElement() {
                return new TextRange(4, RegExpPyNamedGroupRefImpl.this.getTextLength() - 1);
            }

            public PsiElement resolve() {
                return RegExpPyNamedGroupRefImpl.this.resolve();
            }

            @NotNull
            public String getCanonicalText() {
                String string = this.getRangeInElement().substring(RegExpPyNamedGroupRefImpl.this.getText());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpPyNamedGroupRefImpl$2", "getCanonicalText"));
                }
                return string;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                throw new UnsupportedOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/psi/impl/RegExpPyNamedGroupRefImpl$2", "bindToElement"));
                }
                throw new UnsupportedOperationException();
            }

            public boolean isReferenceTo(PsiElement element) {
                return this.resolve() == element;
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpPyNamedGroupRefImpl$2", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            public boolean isSoft() {
                return false;
            }
        };
    }
}

