/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EnumSet;
import java.util.LinkedList;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpTT;

class _RegExLexer
implements FlexLexer {
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int EMBRACED = 4;
    public static final int CLASS1PY = 8;
    public static final int PY_NAMED_GROUP_REF = 22;
    public static final int QUOTED = 2;
    public static final int OPTIONS = 14;
    public static final int PY_COND_REF = 24;
    public static final int YYINITIAL = 0;
    public static final int NAMED_GROUP = 18;
    public static final int CLASS2 = 10;
    public static final int CLASS1 = 6;
    public static final int COMMENT = 16;
    public static final int QUOTED_NAMED_GROUP = 20;
    public static final int PROP = 12;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12};
    private static final String ZZ_CMAP_PACKED = "\b\u0000\u0002+\u0001\u000b\u0001\u0000\u0001+\u00013\u0012\u0000\u0001&\u0001/\u0001\u0000\u00011\u0001\r\u0001\u0000\u0001*\u00012\u0001\u0004\u0001\u0005\u0001\u000f\u0001\u0010\u0001)\u0001#\u0001\u0003\u0001\u0000\u0001\u0002\u0007\"\u0002\u0001\u0001,\u0001\u0000\u00010\u0001.\u0001-\u0001\u000e\u0001\u0000\u0001\u0014\u0001\u0014\u0001\u0018\u0001\u0017\u0001\u001f\u0001\u001d\u0001\u0015\u0001$\u0001\u001a\u0006%\u0001\u001c\u0001\u001e\u0001%\u0001\u0016\u0003%\u0001\u0016\u0001\u0016\u0001%\u0001\u0015\u0001\b\u0001\n\u0001\t\u0001\f\u0001'\u0001\u0000\u0001\u0013\u0001\u0014\u0001\u0019\u0001\u0017\u0001\u0013\u0001\u0013\u0001%\u0001$\u0001\u001a\u0004%\u0001\u0012\u0001%\u0001\u001b\u0001%\u0001\u0012\u0001\u0016\u0001\u0012\u0001!\u0001%\u0001\u0016\u0001 \u0001%\u0001\u0015\u0001\u0006\u0001\u0011\u0001\u0007,\u0000\u0001%\n\u0000\u0001%\u0004\u0000\u0001%\u0005\u0000\u0017%\u0001\u0000\u001f%\u0001\u0000\u013f%\u0019\u0000r%\u0004\u0000\f%\u000e\u0000\u0005%\t\u0000\u0001%\u008b\u0000\u0001%\u000b\u0000\u0001%\u0001\u0000\u0003%\u0001\u0000\u0001%\u0001\u0000\u0014%\u0001\u0000,%\u0001\u0000&%\u0001\u0000\u0005%\u0004\u0000\u0082%\b\u0000E%\u0001\u0000&%\u0002\u0000\u0002%\u0006\u0000\u0010%!\u0000&%\u0002\u0000\u0001%\u0007\u0000'%H\u0000\u001b%\u0005\u0000\u0003%.\u0000\u001a%\u0005\u0000\u000b%\u0015\u0000\n(\u0004\u0000\u0002%\u0001\u0000c%\u0001\u0000\u0001%\u000f\u0000\u0002%\u0007\u0000\u0002%\n(\u0003%\u0002\u0000\u0001%\u0010\u0000\u0001%\u0001\u0000\u001e%\u001d\u0000\u0003%0\u0000&%\u000b\u0000\u0001%\u0152\u00006%\u0003\u0000\u0001%\u0012\u0000\u0001%\u0007\u0000\n%\u0004\u0000\n(\u0015\u0000\b%\u0002\u0000\u0002%\u0002\u0000\u0016%\u0001\u0000\u0007%\u0001\u0000\u0001%\u0003\u0000\u0004%\u0003\u0000\u0001%\u001e\u0000\u0002%\u0001\u0000\u0003%\u0004\u0000\n(\u0002%\u0013\u0000\u0006%\u0004\u0000\u0002%\u0002\u0000\u0016%\u0001\u0000\u0007%\u0001\u0000\u0002%\u0001\u0000\u0002%\u0001\u0000\u0002%\u001f\u0000\u0004%\u0001\u0000\u0001%\u0007\u0000\n(\u0002\u0000\u0003%\u0010\u0000\t%\u0001\u0000\u0003%\u0001\u0000\u0016%\u0001\u0000\u0007%\u0001\u0000\u0002%\u0001\u0000\u0005%\u0003\u0000\u0001%\u0012\u0000\u0001%\u000f\u0000\u0002%\u0004\u0000\n(\u0015\u0000\b%\u0002\u0000\u0002%\u0002\u0000\u0016%\u0001\u0000\u0007%\u0001\u0000\u0002%\u0001\u0000\u0005%\u0003\u0000\u0001%\u001e\u0000\u0002%\u0001\u0000\u0003%\u0004\u0000\n(\u0001\u0000\u0001%\u0011\u0000\u0001%\u0001\u0000\u0006%\u0003\u0000\u0003%\u0001\u0000\u0004%\u0003\u0000\u0002%\u0001\u0000\u0001%\u0001\u0000\u0002%\u0003\u0000\u0002%\u0003\u0000\u0003%\u0003\u0000\b%\u0001\u0000\u0003%-\u0000\t(\u0015\u0000\b%\u0001\u0000\u0003%\u0001\u0000\u0017%\u0001\u0000\n%\u0001\u0000\u0005%&\u0000\u0002%\u0004\u0000\n(\u0015\u0000\b%\u0001\u0000\u0003%\u0001\u0000\u0017%\u0001\u0000\n%\u0001\u0000\u0005%\u0003\u0000\u0001% \u0000\u0001%\u0001\u0000\u0002%\u0004\u0000\n(\u0015\u0000\b%\u0001\u0000\u0003%\u0001\u0000\u0017%\u0001\u0000\u0010%&\u0000\u0002%\u0004\u0000\n(\u0015\u0000\u0012%\u0003\u0000\u0018%\u0001\u0000\t%\u0001\u0000\u0001%\u0002\u0000\u0007%:\u00000%\u0001\u0000\u0002%\f\u0000\u0007%\t\u0000\n('\u0000\u0002%\u0001\u0000\u0001%\u0002\u0000\u0002%\u0001\u0000\u0001%\u0002\u0000\u0001%\u0006\u0000\u0004%\u0001\u0000\u0007%\u0001\u0000\u0003%\u0001\u0000\u0001%\u0001\u0000\u0001%\u0002\u0000\u0002%\u0001\u0000\u0004%\u0001\u0000\u0002%\t\u0000\u0001%\u0002\u0000\u0005%\u0001\u0000\u0001%\t\u0000\n(\u0002\u0000\u0002%\"\u0000\u0001%\u001f\u0000\n(\u0016\u0000\b%\u0001\u0000\"%\u001d\u0000\u0004%t\u0000\"%\u0001\u0000\u0005%\u0001\u0000\u0002%\u0015\u0000\n(\u0006\u0000\u0006%J\u0000&%\n\u0000)%\u0007\u0000Z%\u0005\u0000D%\u0005\u0000R%\u0006\u0000\u0007%\u0001\u0000?%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u0007%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000'%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u001f%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u0007%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u0007%\u0001\u0000\u0007%\u0001\u0000\u0017%\u0001\u0000\u001f%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u0007%\u0001\u0000'%\u0001\u0000\u0013%\u000e\u0000\t(.\u0000U%\f\u0000\u026c%\u0002\u0000\b%\n\u0000\u001a%\u0005\u0000K%\u0015\u0000\r%\u0001\u0000\u0004%\u000e\u0000\u0012%\u000e\u0000\u0012%\u000e\u0000\r%\u0001\u0000\u0003%\u000f\u00004%#\u0000\u0001%\u0004\u0000\u0001%\u0003\u0000\n(&\u0000\n(\u0006\u0000X%\b\u0000)%W\u0000\u001d%)\u0000\n(\u001e%\u0002\u0000\u0005%\u038b\u0000l%\u0094\u0000\u009c%\u0004\u0000Z%\u0006\u0000\u0016%\u0002\u0000\u0006%\u0002\u0000&%\u0002\u0000\u0006%\u0002\u0000\b%\u0001\u0000\u0001%\u0001\u0000\u0001%\u0001\u0000\u0001%\u0001\u0000\u001f%\u0002\u00005%\u0001\u0000\u0007%\u0001\u0000\u0001%\u0003\u0000\u0003%\u0001\u0000\u0007%\u0003\u0000\u0004%\u0002\u0000\u0006%\u0004\u0000\r%\u0005\u0000\u0003%\u0001\u0000\u0007%t\u0000\u0001%\r\u0000\u0001%\u0082\u0000\u0001%\u0004\u0000\u0001%\u0002\u0000\n%\u0001\u0000\u0001%\u0003\u0000\u0005%\u0006\u0000\u0001%\u0001\u0000\u0001%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0001\u0000\u0003%\u0001\u0000\u0007%\u0003\u0000\u0003%\u0005\u0000\u0005%\u0ebb\u0000\u0002%*\u0000\u0005%\u0005\u0000\u0002%\u0004\u0000V%\u0006\u0000\u0003%\u0001\u0000Z%\u0001\u0000\u0004%\u0005\u0000(%\u0004\u0000^%\u0011\u0000\u0018%8\u0000\u0010%\u0200\u0000\u19b6%J\u0000\u51a6%Z\u0000\u048d%\u0773\u0000\u2ba4%\u215c\u0000\u012e%\u0002\u0000;%\u0095\u0000\u0007%\f\u0000\u0005%\u0005\u0000\u0001%\u0001\u0000\n%\u0001\u0000\r%\u0001\u0000\u0005%\u0001\u0000\u0001%\u0001\u0000\u0002%\u0001\u0000\u0002%\u0001\u0000l%!\u0000\u016b%\u0012\u0000@%\u0002\u00006%(\u0000\f%t\u0000\u0005%\u0001\u0000\u0087%\u0013\u0000\n(\u0007\u0000\u001a%\u0006\u0000\u001a%\u000b\u0000Y%\u0003\u0000\u0006%\u0002\u0000\u0006%\u0002\u0000\u0006%\u0002\u0000\u0003%#\u0000";
    private static final char[] ZZ_CMAP = _RegExLexer.zzUnpackCMap("\b\u0000\u0002+\u0001\u000b\u0001\u0000\u0001+\u00013\u0012\u0000\u0001&\u0001/\u0001\u0000\u00011\u0001\r\u0001\u0000\u0001*\u00012\u0001\u0004\u0001\u0005\u0001\u000f\u0001\u0010\u0001)\u0001#\u0001\u0003\u0001\u0000\u0001\u0002\u0007\"\u0002\u0001\u0001,\u0001\u0000\u00010\u0001.\u0001-\u0001\u000e\u0001\u0000\u0001\u0014\u0001\u0014\u0001\u0018\u0001\u0017\u0001\u001f\u0001\u001d\u0001\u0015\u0001$\u0001\u001a\u0006%\u0001\u001c\u0001\u001e\u0001%\u0001\u0016\u0003%\u0001\u0016\u0001\u0016\u0001%\u0001\u0015\u0001\b\u0001\n\u0001\t\u0001\f\u0001'\u0001\u0000\u0001\u0013\u0001\u0014\u0001\u0019\u0001\u0017\u0001\u0013\u0001\u0013\u0001%\u0001$\u0001\u001a\u0004%\u0001\u0012\u0001%\u0001\u001b\u0001%\u0001\u0012\u0001\u0016\u0001\u0012\u0001!\u0001%\u0001\u0016\u0001 \u0001%\u0001\u0015\u0001\u0006\u0001\u0011\u0001\u0007,\u0000\u0001%\n\u0000\u0001%\u0004\u0000\u0001%\u0005\u0000\u0017%\u0001\u0000\u001f%\u0001\u0000\u013f%\u0019\u0000r%\u0004\u0000\f%\u000e\u0000\u0005%\t\u0000\u0001%\u008b\u0000\u0001%\u000b\u0000\u0001%\u0001\u0000\u0003%\u0001\u0000\u0001%\u0001\u0000\u0014%\u0001\u0000,%\u0001\u0000&%\u0001\u0000\u0005%\u0004\u0000\u0082%\b\u0000E%\u0001\u0000&%\u0002\u0000\u0002%\u0006\u0000\u0010%!\u0000&%\u0002\u0000\u0001%\u0007\u0000'%H\u0000\u001b%\u0005\u0000\u0003%.\u0000\u001a%\u0005\u0000\u000b%\u0015\u0000\n(\u0004\u0000\u0002%\u0001\u0000c%\u0001\u0000\u0001%\u000f\u0000\u0002%\u0007\u0000\u0002%\n(\u0003%\u0002\u0000\u0001%\u0010\u0000\u0001%\u0001\u0000\u001e%\u001d\u0000\u0003%0\u0000&%\u000b\u0000\u0001%\u0152\u00006%\u0003\u0000\u0001%\u0012\u0000\u0001%\u0007\u0000\n%\u0004\u0000\n(\u0015\u0000\b%\u0002\u0000\u0002%\u0002\u0000\u0016%\u0001\u0000\u0007%\u0001\u0000\u0001%\u0003\u0000\u0004%\u0003\u0000\u0001%\u001e\u0000\u0002%\u0001\u0000\u0003%\u0004\u0000\n(\u0002%\u0013\u0000\u0006%\u0004\u0000\u0002%\u0002\u0000\u0016%\u0001\u0000\u0007%\u0001\u0000\u0002%\u0001\u0000\u0002%\u0001\u0000\u0002%\u001f\u0000\u0004%\u0001\u0000\u0001%\u0007\u0000\n(\u0002\u0000\u0003%\u0010\u0000\t%\u0001\u0000\u0003%\u0001\u0000\u0016%\u0001\u0000\u0007%\u0001\u0000\u0002%\u0001\u0000\u0005%\u0003\u0000\u0001%\u0012\u0000\u0001%\u000f\u0000\u0002%\u0004\u0000\n(\u0015\u0000\b%\u0002\u0000\u0002%\u0002\u0000\u0016%\u0001\u0000\u0007%\u0001\u0000\u0002%\u0001\u0000\u0005%\u0003\u0000\u0001%\u001e\u0000\u0002%\u0001\u0000\u0003%\u0004\u0000\n(\u0001\u0000\u0001%\u0011\u0000\u0001%\u0001\u0000\u0006%\u0003\u0000\u0003%\u0001\u0000\u0004%\u0003\u0000\u0002%\u0001\u0000\u0001%\u0001\u0000\u0002%\u0003\u0000\u0002%\u0003\u0000\u0003%\u0003\u0000\b%\u0001\u0000\u0003%-\u0000\t(\u0015\u0000\b%\u0001\u0000\u0003%\u0001\u0000\u0017%\u0001\u0000\n%\u0001\u0000\u0005%&\u0000\u0002%\u0004\u0000\n(\u0015\u0000\b%\u0001\u0000\u0003%\u0001\u0000\u0017%\u0001\u0000\n%\u0001\u0000\u0005%\u0003\u0000\u0001% \u0000\u0001%\u0001\u0000\u0002%\u0004\u0000\n(\u0015\u0000\b%\u0001\u0000\u0003%\u0001\u0000\u0017%\u0001\u0000\u0010%&\u0000\u0002%\u0004\u0000\n(\u0015\u0000\u0012%\u0003\u0000\u0018%\u0001\u0000\t%\u0001\u0000\u0001%\u0002\u0000\u0007%:\u00000%\u0001\u0000\u0002%\f\u0000\u0007%\t\u0000\n('\u0000\u0002%\u0001\u0000\u0001%\u0002\u0000\u0002%\u0001\u0000\u0001%\u0002\u0000\u0001%\u0006\u0000\u0004%\u0001\u0000\u0007%\u0001\u0000\u0003%\u0001\u0000\u0001%\u0001\u0000\u0001%\u0002\u0000\u0002%\u0001\u0000\u0004%\u0001\u0000\u0002%\t\u0000\u0001%\u0002\u0000\u0005%\u0001\u0000\u0001%\t\u0000\n(\u0002\u0000\u0002%\"\u0000\u0001%\u001f\u0000\n(\u0016\u0000\b%\u0001\u0000\"%\u001d\u0000\u0004%t\u0000\"%\u0001\u0000\u0005%\u0001\u0000\u0002%\u0015\u0000\n(\u0006\u0000\u0006%J\u0000&%\n\u0000)%\u0007\u0000Z%\u0005\u0000D%\u0005\u0000R%\u0006\u0000\u0007%\u0001\u0000?%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u0007%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000'%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u001f%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u0007%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u0007%\u0001\u0000\u0007%\u0001\u0000\u0017%\u0001\u0000\u001f%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0002\u0000\u0007%\u0001\u0000'%\u0001\u0000\u0013%\u000e\u0000\t(.\u0000U%\f\u0000\u026c%\u0002\u0000\b%\n\u0000\u001a%\u0005\u0000K%\u0015\u0000\r%\u0001\u0000\u0004%\u000e\u0000\u0012%\u000e\u0000\u0012%\u000e\u0000\r%\u0001\u0000\u0003%\u000f\u00004%#\u0000\u0001%\u0004\u0000\u0001%\u0003\u0000\n(&\u0000\n(\u0006\u0000X%\b\u0000)%W\u0000\u001d%)\u0000\n(\u001e%\u0002\u0000\u0005%\u038b\u0000l%\u0094\u0000\u009c%\u0004\u0000Z%\u0006\u0000\u0016%\u0002\u0000\u0006%\u0002\u0000&%\u0002\u0000\u0006%\u0002\u0000\b%\u0001\u0000\u0001%\u0001\u0000\u0001%\u0001\u0000\u0001%\u0001\u0000\u001f%\u0002\u00005%\u0001\u0000\u0007%\u0001\u0000\u0001%\u0003\u0000\u0003%\u0001\u0000\u0007%\u0003\u0000\u0004%\u0002\u0000\u0006%\u0004\u0000\r%\u0005\u0000\u0003%\u0001\u0000\u0007%t\u0000\u0001%\r\u0000\u0001%\u0082\u0000\u0001%\u0004\u0000\u0001%\u0002\u0000\n%\u0001\u0000\u0001%\u0003\u0000\u0005%\u0006\u0000\u0001%\u0001\u0000\u0001%\u0001\u0000\u0001%\u0001\u0000\u0004%\u0001\u0000\u0003%\u0001\u0000\u0007%\u0003\u0000\u0003%\u0005\u0000\u0005%\u0ebb\u0000\u0002%*\u0000\u0005%\u0005\u0000\u0002%\u0004\u0000V%\u0006\u0000\u0003%\u0001\u0000Z%\u0001\u0000\u0004%\u0005\u0000(%\u0004\u0000^%\u0011\u0000\u0018%8\u0000\u0010%\u0200\u0000\u19b6%J\u0000\u51a6%Z\u0000\u048d%\u0773\u0000\u2ba4%\u215c\u0000\u012e%\u0002\u0000;%\u0095\u0000\u0007%\f\u0000\u0005%\u0005\u0000\u0001%\u0001\u0000\n%\u0001\u0000\r%\u0001\u0000\u0005%\u0001\u0000\u0001%\u0001\u0000\u0002%\u0001\u0000\u0002%\u0001\u0000l%!\u0000\u016b%\u0012\u0000@%\u0002\u00006%(\u0000\f%t\u0000\u0005%\u0001\u0000\u0087%\u0013\u0000\n(\u0007\u0000\u001a%\u0006\u0000\u001a%\u000b\u0000Y%\u0003\u0000\u0006%\u0002\u0000\u0006%\u0002\u0000\u0006%\u0002\u0000\u0003%#\u0000");
    private static final int[] ZZ_ACTION = _RegExLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0007\u0000\u0001\u0001\u0001\u0002\u0004\u0000\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0003\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\t\u0001\u001e\u0001\u0003\u0001\u001f\u0001 \u0001\u001f\u0001!\u0001\"\u0001\u0001\u0001#\u0001$\u0001\u0002\u0001%\u0001&\u0001'\u0001(\u0001\u0000\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u00021\u00012\u0001\t\u00013\u00014\u00015\u0001*\u00016\u00017\u00018\u00019\u0001:\u0001;\u0001\u0000\u0001<\u0001=\u0001>\u0001?\u0001\u0000\u0001@\u0001A\u0001B\u0001C\u00024\u00025\u0001*\u0001D\u0001E\u0001F\u0001G\u0001\u0000\u0001B\u00014\u0001H\u00025\u0001I\u0001J\u0001B\u00035\u0001K";
    private static final int[] ZZ_ROWMAP = _RegExLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00004\u0000h\u0000\u009c\u0000\u00d0\u0000\u0104\u0000\u0138\u0000\u016c\u0000\u01a0\u0000\u01d4\u0000\u0208\u0000\u023c\u0000\u0270\u0000\u02a4\u0000\u02a4\u0000\u02d8\u0000\u02a4\u0000\u02a4\u0000\u030c\u0000\u0340\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u0374\u0000\u02a4\u0000\u03a8\u0000\u02a4\u0000\u03dc\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u0410\u0000\u02a4\u0000\u0444\u0000\u02a4\u0000\u0478\u0000\u02a4\u0000\u02a4\u0000\u030c\u0000\u02a4\u0000\u02a4\u0000\u04ac\u0000\u04e0\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u0514\u0000\u02a4\u0000\u0548\u0000\u02a4\u0000\u057c\u0000\u05b0\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u05e4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u0618\u0000\u064c\u0000\u0680\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u06b4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u06e8\u0000\u071c\u0000\u02a4\u0000\u02a4\u0000\u0750\u0000\u02a4\u0000\u0784\u0000\u07b8\u0000\u07ec\u0000\u0820\u0000\u0854\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u02a4\u0000\u0888\u0000\u08bc\u0000\u02a4\u0000\u02a4\u0000\u08f0\u0000\u0924\u0000\u057c\u0000\u02a4\u0000\u02a4\u0000\u0958\u0000\u098c\u0000\u02a4\u0000\u02a4";
    private static final int[] ZZ_TRANS = _RegExLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0003\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u000e\u0001\u0013\u0001\u000e\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0011\u000e\u0001\u001c\u0002\u000e\u0001\u001d\u0004\u000e\u0001\u0015\u0005\u000e\u0001\u001e\u0001\u000e\u0001\u0015\n\u000e\u0001\u001f)\u000e\u0001 \u0002!\u0004 \u0001\"\n \u0010#\u0001!\u0001 \u0002#\u0002 \u0001!\u0001$\n \t%\u0001&\u0001%\u0001\u00003%\u0001\u0000\u0001''%\u0006\u000e\u0001\u0012\u0001\u000e\u0001(\u0001)\u0001*\u0001+\u0001\u0016\u0016\u000e\u0001\u001c\u0006\u000e\u0001,\u0001+\u0007\u000e\u0001+\u0006-\u0001.\u0001-\u0001/\u0001-\u0001\u0014)-\u00050\u00011\f0\u00102\u00010\u00013\u00022\u00060\u00014\u00070\u000b\t\u00015'\t\u00015\u00120\u0010#\u00020\u0002#\u00070\u00016\u00180\u0010#\u00020\u0002#\f0\u00017\u00060\u00011\f0\u0010#\u00020\u0002#\u000f0\u0002!\u00020\u00011\f0\u0010#\u0001!\u00010\u0002#\u00020\u0001!\u000b0B\u0000\u00018.\u0000\u00019\u0002\u0000\u0001:'\u0000\u0001;\u0001<\u0001=\u0004>\u0001;\u0001>\u0001;\u0001>\u0001?\u0006>\u0002@\u0002A\u0002B\u0001C\u0001D\u0001C\u0002E\u0001F\u0001G\u0001F\u0001H\u0001I\u0001J\u0001>\u0001K\u0001F\u0001?\u0004;\u0001?\u0007;\u0001?\u001f\u0000\u0001L\u0015\u0000\u0002!\u001f\u0000\u0001!\u0005\u0000\u0001!\f\u0000\u0002#\u000f\u0000\u0011#\u0001\u0000\u0002#\u0001\u0000\u0002#\u0014\u0000\u0001M\u0002\u0000\u0001:'\u0000\u0001;\u0001<\u0001=\u0004>\u0001;\u0001>\u0001N\u0001>\u0001?\u0006>\u0002@\u0002A\u0002B\u0001C\u0001D\u0001C\u0002E\u0001F\u0001G\u0001F\u0001H\u0001I\u0001J\u0001>\u0001K\u0001F\u0001?\u0004;\u0001?\u0007;\u0001?*\u0000\u0001O\u001b\u0000\u00102\u0002\u0000\u00022 \u0000\u00103\u0002\u0000\u00023\u0012\u0000\u0001P\u0017\u0000\u0001Q\u000f\u0000\u0002R\u0001S\u0001T\u0001U\u0001V\u0001W\n\u0000\u0001X+\u0000\u0002<\u001f\u0000\u0001<\u0013\u0000\u0001Y\u001f\u0000\u0001Y\u0011\u00004Z\u0001[\u0002\\\u0010[\u0002\\\u0002[\u0003\\\u0003[\u0001\\\u0001[\u0001\\\u0002[\u0001\\\u0011[\u0001]\u0002^\u0010]\u0002^\u0002]\u0003^\u0003]\u0001^\u0001]\u0001^\u0002]\u0001^\u0011]\u0001\u0000\u0001<\u0001_\u001f\u0000\u0001_?\u0000\u0001`\u0001\u0000\u0001a1\u0000\u0001b\u0001c\u0004\u0000\u0005d\u0001\u0000.d\u0002\u0000\u0001e\u001f\u0000\u0001e\u0011\u00005f\u0002g\u0010f\u0002g\u0002f\u0003g\u0003f\u0001g\u0001f\u0001g\u0002f\u0001g\u0011f5h\u0002i\u0010h\u0002i\u0002h\u0003i\u0003h\u0001i\u0001h\u0001i\u0002h\u0001i\u0011h\u0001\u0000\u0001<\u0001j\u001f\u0000\u0001j\u0011\u0000\u0005d\u0001k.d\u0002\u0000\u0001l\u001f\u0000\u0001l\u0011\u00005m\u0002n\u0010m\u0002n\u0002m\u0003n\u0003m\u0001n\u0001m\u0001n\u0002m\u0001n\u0011m5o\u0002p\u0010o\u0002p\u0002o\u0003p\u0003o\u0001p\u0001o\u0001p\u0002o\u0001p\u0011o";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final char[] EMPTY_BUFFER = new char[0];
    private static final int YYEOF = -1;
    private static Reader zzReader = null;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _RegExLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0007\u0000\u0002\u0001\u0004\u0000\u0002\t\u0001\u0001\u0002\t\u0002\u0001\n\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0004\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0002\t\u0001\u0001\u0002\t\u0002\u0001\u0004\t\u0001\u0001\u0001\t\u0001\u0000\u0001\t\u0002\u0001\u0006\t\u0001\u0001\u0003\t\u0003\u0001\u0006\t\u0001\u0000\u0003\t\u0001\u0001\u0001\u0000\u0002\t\u0001\u0001\u0001\t\u0005\u0001\u0004\t\u0001\u0000\u0001\u0001\u0002\t\u0003\u0001\u0002\t\u0002\u0001\u0002\t";
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private char[] zzBufferArray;
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private final LinkedList<Integer> states = new LinkedList();
    private boolean xmlSchemaMode;
    private boolean allowDanglingMetacharacters;
    private boolean allowNestedCharacterClasses;
    private boolean allowOctalNoLeadingZero;
    private boolean allowHexDigitClass;
    boolean commentMode = false;

    private static int[] zzUnpackAction() {
        int[] result = new int[112];
        int offset = 0;
        offset = _RegExLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[112];
        int offset = 0;
        offset = _RegExLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[2496];
        int offset = 0;
        offset = _RegExLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[112];
        int offset = 0;
        offset = _RegExLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    _RegExLexer(EnumSet<RegExpCapability> capabilities) {
        this((Reader)null);
        this.xmlSchemaMode = capabilities.contains((Object)RegExpCapability.XML_SCHEMA_MODE);
        this.allowDanglingMetacharacters = capabilities.contains((Object)RegExpCapability.DANGLING_METACHARACTERS);
        this.allowNestedCharacterClasses = capabilities.contains((Object)RegExpCapability.NESTED_CHARACTER_CLASSES);
        this.allowOctalNoLeadingZero = capabilities.contains((Object)RegExpCapability.OCTAL_NO_LEADING_ZERO);
        this.commentMode = capabilities.contains((Object)RegExpCapability.COMMENT_MODE);
        this.allowHexDigitClass = capabilities.contains((Object)RegExpCapability.ALLOW_HEX_DIGIT_CLASS);
    }

    private void yypushstate(int state) {
        this.states.addFirst(this.yystate());
        this.yybegin(state);
    }

    private void yypopstate() {
        int state = this.states.removeFirst();
        this.yybegin(state);
    }

    private void handleOptions() {
        String o = ((Object)this.yytext()).toString();
        if (o.contains("x")) {
            this.commentMode = !o.startsWith("-");
        }
    }

    _RegExLexer(Reader in) {
        zzReader = in;
    }

    _RegExLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 1338) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzBufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzPushbackPos = 0;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBufferArray != null ? this.zzBufferArray[this.zzStartRead + pos] : this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
        }
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        char[] zzBufferArrayL = this.zzBufferArray;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block152: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 75: {
                    return RegExpTT.UNICODE_CHAR;
                }
                case 76: {
                    continue block152;
                }
                case 7: {
                    if (this.yystate() != 10) {
                        this.yypushstate(4);
                    }
                    return RegExpTT.LBRACE;
                }
                case 77: {
                    continue block152;
                }
                case 24: {
                    return RegExpTT.COMMA;
                }
                case 78: {
                    continue block152;
                }
                case 61: {
                    return RegExpTT.POS_LOOKAHEAD;
                }
                case 79: {
                    continue block152;
                }
                case 74: {
                    return RegExpTT.COMMENT;
                }
                case 80: {
                    continue block152;
                }
                case 69: {
                    this.yybegin(18);
                    return RegExpTT.PYTHON_NAMED_GROUP;
                }
                case 81: {
                    continue block152;
                }
                case 14: {
                    return RegExpTT.STAR;
                }
                case 82: {
                    continue block152;
                }
                case 28: {
                    if (this.allowNestedCharacterClasses) {
                        this.yypushstate(10);
                        return RegExpTT.CLASS_BEGIN;
                    }
                    return RegExpTT.CHARACTER;
                }
                case 83: {
                    continue block152;
                }
                case 59: {
                    this.yybegin(24);
                    return RegExpTT.PYTHON_COND_REF;
                }
                case 84: {
                    continue block152;
                }
                case 48: {
                    return RegExpTT.CHAR_CLASS;
                }
                case 85: {
                    continue block152;
                }
                case 35: {
                    this.handleOptions();
                    return RegExpTT.OPTIONS_OFF;
                }
                case 86: {
                    continue block152;
                }
                case 40: {
                    this.zzMarkedPos = this.zzStartRead + 1;
                    this.yypushstate(6);
                    return RegExpTT.CLASS_BEGIN;
                }
                case 87: {
                    continue block152;
                }
                case 55: {
                    this.yypopstate();
                    return RegExpTT.QUOTE_END;
                }
                case 88: {
                    continue block152;
                }
                case 34: {
                    this.yybegin(0);
                    return RegExpTT.GROUP_END;
                }
                case 89: {
                    continue block152;
                }
                case 5: {
                    return RegExpTT.GROUP_BEGIN;
                }
                case 90: {
                    continue block152;
                }
                case 36: {
                    this.yybegin(0);
                    return RegExpTT.COLON;
                }
                case 91: {
                    continue block152;
                }
                case 6: {
                    return RegExpTT.GROUP_END;
                }
                case 92: {
                    continue block152;
                }
                case 25: {
                    assert (false) : this.yytext();
                }
                case 93: {
                    continue block152;
                }
                case 18: {
                    return this.commentMode ? TokenType.WHITE_SPACE : RegExpTT.CHARACTER;
                }
                case 94: {
                    continue block152;
                }
                case 45: {
                    return this.commentMode ? RegExpTT.CHARACTER : RegExpTT.REDUNDANT_ESCAPE;
                }
                case 95: {
                    continue block152;
                }
                case 23: {
                    return RegExpTT.NAME;
                }
                case 96: {
                    continue block152;
                }
                case 29: {
                    this.yypopstate();
                    return RegExpTT.CLASS_END;
                }
                case 97: {
                    continue block152;
                }
                case 33: {
                    this.yybegin(0);
                    return RegExpTT.BAD_CHARACTER;
                }
                case 98: {
                    continue block152;
                }
                case 51: {
                    this.yypushstate(2);
                    return RegExpTT.QUOTE_BEGIN;
                }
                case 99: {
                    continue block152;
                }
                case 21: {
                    return RegExpTT.NUMBER;
                }
                case 100: {
                    continue block152;
                }
                case 4: {
                    return RegExpTT.DOT;
                }
                case 101: {
                    continue block152;
                }
                case 71: {
                    return RegExpTT.NEG_LOOKBEHIND;
                }
                case 102: {
                    continue block152;
                }
                case 43: {
                    return this.allowOctalNoLeadingZero ? RegExpTT.OCT_CHAR : RegExpTT.BAD_OCT_VALUE;
                }
                case 103: {
                    continue block152;
                }
                case 62: {
                    return RegExpTT.NEG_LOOKAHEAD;
                }
                case 104: {
                    continue block152;
                }
                case 10: {
                    return this.commentMode ? TokenType.WHITE_SPACE : RegExpTT.CTRL_CHARACTER;
                }
                case 105: {
                    continue block152;
                }
                case 60: {
                    return RegExpTT.NON_CAPT_GROUP;
                }
                case 106: {
                    continue block152;
                }
                case 64: {
                    this.yybegin(20);
                    return RegExpTT.RUBY_QUOTED_NAMED_GROUP;
                }
                case 107: {
                    continue block152;
                }
                case 19: {
                    if (this.commentMode) {
                        this.yypushstate(16);
                        return RegExpTT.COMMENT;
                    }
                    return RegExpTT.CHARACTER;
                }
                case 108: {
                    continue block152;
                }
                case 50: {
                    this.yypushstate(12);
                    return RegExpTT.PROPERTY;
                }
                case 109: {
                    continue block152;
                }
                case 70: {
                    return RegExpTT.POS_LOOKBEHIND;
                }
                case 110: {
                    continue block152;
                }
                case 42: {
                    return this.yystate() != 10 ? RegExpTT.BACKREF : RegExpTT.ESC_CHARACTER;
                }
                case 111: {
                    continue block152;
                }
                case 72: {
                    return RegExpTT.HEX_CHAR;
                }
                case 112: {
                    continue block152;
                }
                case 1: {
                    this.handleOptions();
                    return RegExpTT.OPTIONS_ON;
                }
                case 113: {
                    continue block152;
                }
                case 58: {
                    return this.allowNestedCharacterClasses ? RegExpTT.ANDAND : RegExpTT.CHARACTER;
                }
                case 114: {
                    continue block152;
                }
                case 2: {
                    this.yypopstate();
                    return RegExpTT.COMMENT;
                }
                case 115: {
                    continue block152;
                }
                case 17: {
                    return RegExpTT.MINUS;
                }
                case 116: {
                    continue block152;
                }
                case 46: {
                    return RegExpTT.ESC_CTRL_CHARACTER;
                }
                case 117: {
                    continue block152;
                }
                case 32: {
                    this.yypopstate();
                    this.yypushstate(4);
                    return RegExpTT.LBRACE;
                }
                case 118: {
                    continue block152;
                }
                case 57: {
                    if (!this.allowNestedCharacterClasses) {
                        return RegExpTT.CHARACTER;
                    }
                    return RegExpTT.REDUNDANT_ESCAPE;
                }
                case 119: {
                    continue block152;
                }
                case 13: {
                    return RegExpTT.QUEST;
                }
                case 120: {
                    continue block152;
                }
                case 20: {
                    if (this.allowDanglingMetacharacters) {
                        this.yypopstate();
                        this.yypushback(1);
                    } else {
                        return RegExpTT.BAD_CHARACTER;
                    }
                }
                case 121: {
                    continue block152;
                }
                case 54: {
                    return this.allowHexDigitClass ? RegExpTT.CHAR_CLASS : StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                }
                case 122: {
                    continue block152;
                }
                case 15: {
                    return RegExpTT.PLUS;
                }
                case 123: {
                    continue block152;
                }
                case 66: {
                    return RegExpTT.OCT_CHAR;
                }
                case 124: {
                    continue block152;
                }
                case 73: {
                    if (this.allowOctalNoLeadingZero) {
                        return RegExpTT.OCT_CHAR;
                    }
                    return this.yystate() != 10 ? RegExpTT.BACKREF : RegExpTT.ESC_CHARACTER;
                }
                case 125: {
                    continue block152;
                }
                case 38: {
                    this.yybegin(0);
                    return RegExpTT.QUOTE;
                }
                case 126: {
                    continue block152;
                }
                case 31: {
                    this.yypopstate();
                    this.yypushback(1);
                }
                case 127: {
                    continue block152;
                }
                case 27: {
                    this.yybegin(6);
                    return RegExpTT.CARET;
                }
                case 128: {
                    continue block152;
                }
                case 37: {
                    this.yybegin(0);
                    return RegExpTT.GT;
                }
                case 129: {
                    continue block152;
                }
                case 68: {
                    this.yybegin(22);
                    return RegExpTT.PYTHON_NAMED_GROUP_REF;
                }
                case 130: {
                    continue block152;
                }
                case 16: {
                    return RegExpTT.UNION;
                }
                case 131: {
                    continue block152;
                }
                case 3: {
                    return RegExpTT.CHARACTER;
                }
                case 132: {
                    continue block152;
                }
                case 63: {
                    this.yybegin(18);
                    return RegExpTT.RUBY_NAMED_GROUP;
                }
                case 133: {
                    continue block152;
                }
                case 39: {
                    this.yybegin(14);
                    return RegExpTT.SET_OPTIONS;
                }
                case 134: {
                    continue block152;
                }
                case 26: {
                    this.yybegin(10);
                    return RegExpTT.CHARACTER;
                }
                case 135: {
                    continue block152;
                }
                case 67: {
                    if (this.xmlSchemaMode) {
                        this.yypushback(1);
                        return RegExpTT.CHAR_CLASS;
                    }
                    return RegExpTT.CTRL;
                }
                case 136: {
                    continue block152;
                }
                case 30: {
                    return this.commentMode ? TokenType.WHITE_SPACE : RegExpTT.ESC_CHARACTER;
                }
                case 137: {
                    continue block152;
                }
                case 12: {
                    return RegExpTT.DOLLAR;
                }
                case 138: {
                    continue block152;
                }
                case 49: {
                    if (this.xmlSchemaMode) {
                        return RegExpTT.CHAR_CLASS;
                    }
                    return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                }
                case 139: {
                    continue block152;
                }
                case 41: {
                    return RegExpTT.REDUNDANT_ESCAPE;
                }
                case 140: {
                    continue block152;
                }
                case 47: {
                    return this.yystate() != 10 ? RegExpTT.BOUNDARY : RegExpTT.ESC_CHARACTER;
                }
                case 141: {
                    continue block152;
                }
                case 8: {
                    this.yypushstate(10);
                    return RegExpTT.CLASS_BEGIN;
                }
                case 142: {
                    continue block152;
                }
                case 22: {
                    this.yypopstate();
                    return RegExpTT.RBRACE;
                }
                case 143: {
                    continue block152;
                }
                case 53: {
                    return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                }
                case 144: {
                    continue block152;
                }
                case 52: {
                    return RegExpTT.BAD_HEX_VALUE;
                }
                case 145: {
                    continue block152;
                }
                case 9: {
                    return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                }
                case 146: {
                    continue block152;
                }
                case 11: {
                    return RegExpTT.CARET;
                }
                case 147: {
                    continue block152;
                }
                case 44: {
                    return RegExpTT.ESC_CHARACTER;
                }
                case 148: {
                    continue block152;
                }
                case 56: {
                    this.zzMarkedPos = this.zzStartRead + 1;
                    if (this.allowNestedCharacterClasses) {
                        this.yypushstate(6);
                        return RegExpTT.CLASS_BEGIN;
                    }
                    return RegExpTT.CHARACTER;
                }
                case 149: {
                    continue block152;
                }
                case 65: {
                    this.zzMarkedPos = this.zzStartRead + 1;
                    if (!this.allowNestedCharacterClasses) {
                        this.yypushstate(8);
                    } else {
                        this.yypushstate(10);
                    }
                    return RegExpTT.CLASS_BEGIN;
                }
                case 150: {
                    continue block152;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return null;
            }
            this.zzScanError(1);
        }
    }
}

