/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPyCondRef;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpLanguageHosts
extends ClassExtension<RegExpLanguageHost> {
    private static final RegExpLanguageHosts INSTANCE = new RegExpLanguageHosts();
    private final DefaultRegExpPropertiesProvider myDefaultProvider = DefaultRegExpPropertiesProvider.getInstance();

    public static RegExpLanguageHosts getInstance() {
        return INSTANCE;
    }

    private RegExpLanguageHosts() {
        super("com.intellij.regExpLanguageHost");
    }

    @Nullable
    private static RegExpLanguageHost findRegExpHost(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
        if (host instanceof RegExpLanguageHost) {
            return (RegExpLanguageHost)host;
        }
        if (host != null) {
            return (RegExpLanguageHost)INSTANCE.forClass(host.getClass());
        }
        return null;
    }

    public boolean isRedundantEscape(@NotNull RegExpChar ch, @NotNull String text) {
        if (ch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/RegExpLanguageHosts", "isRedundantEscape"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/regexp/RegExpLanguageHosts", "isRedundantEscape"));
        }
        if (text.length() <= 1) {
            return false;
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ch);
        if (host != null) {
            char c = text.charAt(1);
            boolean needsEscaping = host.characterNeedsEscaping(c);
            return !needsEscaping;
        }
        return !"\\]".equals(text) && !"\\}".equals(text);
    }

    public boolean supportsNamedGroupSyntax(@Nullable RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        return host != null && host.supportsNamedGroupSyntax(group);
    }

    public boolean supportsPerl5EmbeddedComments(@Nullable PsiComment comment) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost((PsiElement)comment);
        return host != null && host.supportsPerl5EmbeddedComments();
    }

    public boolean supportsPythonConditionalRefs(@Nullable RegExpPyCondRef condRef) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(condRef);
        return host != null && host.supportsPythonConditionalRefs();
    }

    public boolean supportsPossessiveQuantifiers(@Nullable RegExpQuantifier quantifier) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(quantifier);
        return host == null || host.supportsPossessiveQuantifiers();
    }

    public boolean isValidCategory(@NotNull PsiElement element, @NotNull String category) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/RegExpLanguageHosts", "isValidCategory"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/regexp/RegExpLanguageHosts", "isValidCategory"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        return host != null ? host.isValidCategory(category) : this.myDefaultProvider.isValidCategory(category);
    }

    @NotNull
    public String[][] getAllKnownProperties(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/RegExpLanguageHosts", "getAllKnownProperties"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        String[][] stringArray = host != null ? host.getAllKnownProperties() : this.myDefaultProvider.getAllKnownProperties();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpLanguageHosts", "getAllKnownProperties"));
        }
        return stringArray;
    }

    @Nullable
    String getPropertyDescription(@NotNull PsiElement element, @Nullable String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/RegExpLanguageHosts", "getPropertyDescription"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        return host != null ? host.getPropertyDescription(name) : this.myDefaultProvider.getPropertyDescription(name);
    }

    @NotNull
    String[][] getKnownCharacterClasses(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/RegExpLanguageHosts", "getKnownCharacterClasses"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        String[][] stringArray = host != null ? host.getKnownCharacterClasses() : this.myDefaultProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpLanguageHosts", "getKnownCharacterClasses"));
        }
        return stringArray;
    }
}

