/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.WhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ExtractWhileLoopConditionToIfStatementIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        WhileLoopPredicate whileLoopPredicate = new WhileLoopPredicate();
        if (whileLoopPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/whileloop/ExtractWhileLoopConditionToIfStatementIntention", "getElementPredicate"));
        }
        return whileLoopPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement newElement;
        PsiBlockStatement blockStatement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/whileloop/ExtractWhileLoopConditionToIfStatementIntention", "processIntention"));
        }
        PsiWhileStatement whileStatement = (PsiWhileStatement)element.getParent();
        if (whileStatement == null) {
            return;
        }
        PsiExpression condition = whileStatement.getCondition();
        if (condition == null) {
            return;
        }
        String conditionText = condition.getText();
        PsiManager manager = whileStatement.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiExpression newCondition = factory.createExpressionFromText("true", (PsiElement)whileStatement);
        condition.replace((PsiElement)newCondition);
        PsiStatement body = whileStatement.getBody();
        String ifStatementText = "if (!(" + conditionText + ")) break;";
        PsiStatement ifStatement = factory.createStatementFromText(ifStatementText, (PsiElement)whileStatement);
        if (body instanceof PsiBlockStatement) {
            blockStatement = (PsiBlockStatement)body;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement bodyElement = codeBlock.getFirstBodyElement();
            newElement = codeBlock.addBefore((PsiElement)ifStatement, bodyElement);
        } else if (body != null) {
            blockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)whileStatement);
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            codeBlock.add((PsiElement)ifStatement);
            if (!(body instanceof PsiEmptyStatement)) {
                codeBlock.add((PsiElement)body);
            }
            newElement = body.replace((PsiElement)blockStatement);
        } else {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        codeStyleManager.reformat(newElement);
    }
}

