/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.varargs.ConvertVarargParameterToArrayPredicate;
import org.jetbrains.annotations.NotNull;

public class ConvertVarargParameterToArrayIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConvertVarargParameterToArrayPredicate convertVarargParameterToArrayPredicate = new ConvertVarargParameterToArrayPredicate();
        if (convertVarargParameterToArrayPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/varargs/ConvertVarargParameterToArrayIntention", "getElementPredicate"));
        }
        return convertVarargParameterToArrayPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/varargs/ConvertVarargParameterToArrayIntention", "processIntention"));
        }
        PsiParameterList parameterList = (PsiParameterList)element;
        ConvertVarargParameterToArrayIntention.convertVarargsToArray(parameterList);
    }

    private static void convertVarargsToArray(PsiParameterList parameterList) throws IncorrectOperationException {
        PsiParameter[] parameters = parameterList.getParameters();
        if (parameters.length == 0) {
            return;
        }
        PsiParameter lastParameter = parameters[parameters.length - 1];
        if (lastParameter == null || !lastParameter.isVarArgs()) {
            return;
        }
        PsiEllipsisType type = (PsiEllipsisType)lastParameter.getType();
        PsiMethod method = (PsiMethod)parameterList.getParent();
        Query query = ReferencesSearch.search((PsiElement)method);
        PsiType componentType = type.getComponentType();
        String typeText = componentType.getCanonicalText();
        int parameterIndex = parameterList.getParameterIndex(lastParameter);
        for (PsiReference reference : query) {
            PsiElement referenceElement = reference.getElement();
            if (!(referenceElement instanceof PsiReferenceExpression)) continue;
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)referenceElement;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)referenceExpression.getParent();
            ConvertVarargParameterToArrayIntention.modifyCall(methodCallExpression, typeText, parameterIndex);
        }
        PsiType arrayType = type.toArrayType();
        Project project = lastParameter.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiTypeElement newTypeElement = factory.createTypeElement(arrayType);
        PsiTypeElement typeElement = lastParameter.getTypeElement();
        typeElement.replace((PsiElement)newTypeElement);
    }

    public static void modifyCall(PsiMethodCallExpression methodCallExpression, String arrayTypeText, int indexOfFirstVarargArgument) throws IncorrectOperationException {
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        StringBuilder builder = new StringBuilder("new ");
        builder.append(arrayTypeText);
        builder.append("[]{");
        if (arguments.length > indexOfFirstVarargArgument) {
            PsiExpression firstArgument = arguments[indexOfFirstVarargArgument];
            String firstArgumentText = firstArgument.getText();
            builder.append(firstArgumentText);
            for (int i = indexOfFirstVarargArgument + 1; i < arguments.length; ++i) {
                builder.append(',');
                builder.append(arguments[i].getText());
            }
        }
        builder.append('}');
        Project project = methodCallExpression.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression arrayExpression = factory.createExpressionFromText(builder.toString(), (PsiElement)methodCallExpression);
        if (arguments.length > indexOfFirstVarargArgument) {
            PsiExpression firstArgument = arguments[indexOfFirstVarargArgument];
            argumentList.deleteChildRange((PsiElement)firstArgument, (PsiElement)arguments[arguments.length - 1]);
            argumentList.add((PsiElement)arrayExpression);
        } else {
            argumentList.add((PsiElement)arrayExpression);
        }
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences((PsiElement)argumentList);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat((PsiElement)argumentList);
    }
}

