/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.unicode;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementEditorPredicate;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnicodeUnescapeIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/unicode/UnicodeUnescapeIntention", "processIntention"));
        }
    }

    @Override
    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ipp/unicode/UnicodeUnescapeIntention", "processIntention"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            int index;
            Document document = editor.getDocument();
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            String text = document.getText(new TextRange(start, end));
            int textLength = end - start;
            StringBuilder replacement = new StringBuilder(textLength);
            int anchor = 0;
            while ((index = UnicodeUnescapeIntention.indexOfUnicodeEscape(text, anchor + 1)) >= 0) {
                replacement.append(text.substring(anchor, index));
                int hexStart = index + 1;
                while (text.charAt(hexStart) == 'u') {
                    ++hexStart;
                }
                anchor = hexStart + 4;
                int c = Integer.parseInt(text.substring(hexStart, anchor), 16);
                replacement.appendCodePoint(c);
            }
            replacement.append(text.substring(anchor, textLength));
            document.replaceString(start, end, (CharSequence)replacement);
        } else {
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            int lineStartOffset = document.getLineStartOffset(lineNumber);
            String line = document.getText(new TextRange(lineStartOffset, document.getLineEndOffset(lineNumber)));
            int column = caretModel.getLogicalPosition().column;
            int index1 = UnicodeUnescapeIntention.indexOfUnicodeEscape(line, column);
            int index2 = UnicodeUnescapeIntention.indexOfUnicodeEscape(line, column + 1);
            int escapeStart = index2 == column ? index2 : index1;
            int hexStart = escapeStart + 1;
            while (line.charAt(hexStart) == 'u') {
                ++hexStart;
            }
            int c = Integer.parseInt(line.substring(hexStart, hexStart + 4), 16);
            document.replaceString(lineStartOffset + escapeStart, lineStartOffset + hexStart + 4, (CharSequence)String.valueOf((char)c));
        }
    }

    private static int indexOfUnicodeEscape(@NotNull String text, int offset) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/unicode/UnicodeUnescapeIntention", "indexOfUnicodeEscape"));
        }
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            int escapeEnd;
            char c = text.charAt(i);
            if (c != '\\') continue;
            boolean isEscape = true;
            for (int previousChar = i - 1; previousChar >= 0 && text.charAt(previousChar) == '\\'; --previousChar) {
                isEscape = !isEscape;
            }
            if (!isEscape) continue;
            int nextChar = i;
            while (++nextChar < length && text.charAt(nextChar) == 'u') {
            }
            if (nextChar == i + 1 || nextChar + 3 >= length) break;
            if (!StringUtil.isHexDigit((char)text.charAt(nextChar)) || !StringUtil.isHexDigit((char)text.charAt(nextChar + 1)) || !StringUtil.isHexDigit((char)text.charAt(nextChar + 2)) || !StringUtil.isHexDigit((char)text.charAt(nextChar + 3)) || offset > (escapeEnd = nextChar + 4)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        UnicodeEscapePredicate unicodeEscapePredicate = new UnicodeEscapePredicate();
        if (unicodeEscapePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/unicode/UnicodeUnescapeIntention", "getElementPredicate"));
        }
        return unicodeEscapePredicate;
    }

    private static class UnicodeEscapePredicate
    extends PsiElementEditorPredicate {
        private UnicodeEscapePredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element, @Nullable Editor editor) {
            int column;
            if (editor == null) {
                return false;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            Document document = editor.getDocument();
            if (selectionModel.hasSelection()) {
                int start = selectionModel.getSelectionStart();
                int end = selectionModel.getSelectionEnd();
                if (start < 0 || end < 0 || start > end) {
                    return false;
                }
                String text = ((Object)document.getCharsSequence().subSequence(start, end)).toString();
                return UnicodeUnescapeIntention.indexOfUnicodeEscape(text, 1) >= 0;
            }
            CaretModel caretModel = editor.getCaretModel();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            String line = document.getText(new TextRange(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)));
            int index = UnicodeUnescapeIntention.indexOfUnicodeEscape(line, column = caretModel.getLogicalPosition().column);
            return index >= 0 && column >= index;
        }
    }
}

