/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToNestedIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof PsiReturnStatement)) {
                    return false;
                }
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
                if (!(returnValue instanceof PsiPolyadicExpression)) {
                    return false;
                }
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)returnValue;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                return tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/trivialif/ConvertToNestedIfIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/trivialif/ConvertToNestedIfIntention", "processIntention"));
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)element;
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null || ErrorUtil.containsDeepError((PsiElement)returnValue)) {
            return;
        }
        String newStatementText = ConvertToNestedIfIntention.buildIf(returnValue, new StringBuilder()).toString();
        Project project = returnStatement.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiBlockStatement blockStatement = (PsiBlockStatement)elementFactory.createStatementFromText("{" + newStatementText + "}", (PsiElement)returnStatement);
        PsiElement parent = returnStatement.getParent();
        for (PsiStatement st : blockStatement.getCodeBlock().getStatements()) {
            CodeStyleManager.getInstance((Project)project).reformat(parent.addBefore((PsiElement)st, (PsiElement)returnStatement));
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)returnStatement, "return false;");
    }

    private static StringBuilder buildIf(@Nullable PsiExpression expression, StringBuilder out) {
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            PsiExpression[] operands = polyadicExpression.getOperands();
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                for (PsiExpression operand : operands) {
                    ConvertToNestedIfIntention.buildIf(operand, out);
                }
                if (!StringUtil.endsWith((CharSequence)out, (CharSequence)"return true;")) {
                    out.append("return true;");
                }
                return out;
            }
            if (JavaTokenType.OROR.equals(tokenType)) {
                for (PsiExpression operand : operands) {
                    ConvertToNestedIfIntention.buildIf(operand, out);
                    if (StringUtil.endsWith((CharSequence)out, (CharSequence)"return true;")) continue;
                    out.append("return true;");
                }
                return out;
            }
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            ConvertToNestedIfIntention.buildIf(parenthesizedExpression.getExpression(), out);
            return out;
        }
        if (expression != null) {
            out.append("if(").append(expression.getText()).append(")");
        }
        return out;
    }
}

