/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchtoif;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SwitchUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.switchtoif.IfToSwitchPredicate;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceIfWithSwitchIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        IfToSwitchPredicate ifToSwitchPredicate = new IfToSwitchPredicate();
        if (ifToSwitchPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/switchtoif/ReplaceIfWithSwitchIntention", "getElementPredicate"));
        }
        return ifToSwitchPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiStatement elseBranch;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/switchtoif/ReplaceIfWithSwitchIntention", "processIntention"));
        }
        PsiJavaToken switchToken = (PsiJavaToken)element;
        PsiIfStatement ifStatement = (PsiIfStatement)switchToken.getParent();
        if (ifStatement == null) {
            return;
        }
        boolean breaksNeedRelabeled = false;
        PsiStatement breakTarget = null;
        String labelString = "";
        if (ControlFlowUtils.statementContainsNakedBreak((PsiStatement)ifStatement) && (breakTarget = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, (Class[])new Class[]{PsiLoopStatement.class, PsiSwitchStatement.class})) != null) {
            PsiElement parent = breakTarget.getParent();
            if (parent instanceof PsiLabeledStatement) {
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)parent;
                labelString = labeledStatement.getLabelIdentifier().getText();
                breakTarget = labeledStatement;
                breaksNeedRelabeled = true;
            } else {
                labelString = SwitchUtils.findUniqueLabelName((PsiStatement)ifStatement, "label");
                breaksNeedRelabeled = true;
            }
        }
        PsiIfStatement statementToReplace = ifStatement;
        PsiExpression switchExpression = SwitchUtils.getSwitchExpression(ifStatement, 0);
        if (switchExpression == null) {
            return;
        }
        ArrayList<SwitchUtils.IfStatementBranch> branches = new ArrayList<SwitchUtils.IfStatementBranch>(20);
        while (true) {
            PsiExpression condition = ifStatement.getCondition();
            PsiStatement thenBranch = ifStatement.getThenBranch();
            SwitchUtils.IfStatementBranch ifBranch = new SwitchUtils.IfStatementBranch(thenBranch, false);
            ReplaceIfWithSwitchIntention.extractCaseExpressions(condition, switchExpression, ifBranch);
            if (!branches.isEmpty()) {
                ReplaceIfWithSwitchIntention.extractIfComments((PsiElement)ifStatement, ifBranch);
            }
            ReplaceIfWithSwitchIntention.extractStatementComments((PsiElement)thenBranch, ifBranch);
            branches.add(ifBranch);
            elseBranch = ifStatement.getElseBranch();
            if (!(elseBranch instanceof PsiIfStatement)) break;
            ifStatement = (PsiIfStatement)elseBranch;
        }
        if (elseBranch != null) {
            SwitchUtils.IfStatementBranch elseIfBranch = new SwitchUtils.IfStatementBranch(elseBranch, true);
            PsiKeyword elseKeyword = ifStatement.getElseElement();
            ReplaceIfWithSwitchIntention.extractIfComments((PsiElement)elseKeyword, elseIfBranch);
            ReplaceIfWithSwitchIntention.extractStatementComments((PsiElement)elseBranch, elseIfBranch);
            branches.add(elseIfBranch);
        }
        StringBuilder switchStatementText = new StringBuilder();
        switchStatementText.append("switch(").append(switchExpression.getText()).append("){");
        PsiType type = switchExpression.getType();
        boolean castToInt = type != null && type.equalsToText("java.lang.Integer");
        for (SwitchUtils.IfStatementBranch branch : branches) {
            boolean hasConflicts = false;
            for (SwitchUtils.IfStatementBranch testBranch : branches) {
                if (branch == testBranch || !branch.topLevelDeclarationsConflictWith(testBranch)) continue;
                hasConflicts = true;
            }
            ReplaceIfWithSwitchIntention.dumpBranch(branch, castToInt, hasConflicts, breaksNeedRelabeled, labelString, switchStatementText);
        }
        switchStatementText.append('}');
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        if (breaksNeedRelabeled) {
            StringBuilder out = new StringBuilder();
            if (!(breakTarget instanceof PsiLabeledStatement)) {
                out.append(labelString).append(':');
            }
            ReplaceIfWithSwitchIntention.termReplace((PsiElement)breakTarget, (PsiElement)statementToReplace, switchStatementText, out);
            String newStatementText = out.toString();
            PsiStatement newStatement = factory.createStatementFromText(newStatementText, element);
            breakTarget.replace((PsiElement)newStatement);
        } else {
            PsiStatement newStatement = factory.createStatementFromText(switchStatementText.toString(), element);
            statementToReplace.replace((PsiElement)newStatement);
        }
    }

    @Nullable
    public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, Class<? extends PsiElement> ... stopAt) {
        PsiElement sibling;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ipp/switchtoif/ReplaceIfWithSwitchIntention", "getPrevSiblingOfType"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/siyeh/ipp/switchtoif/ReplaceIfWithSwitchIntention", "getPrevSiblingOfType"));
        }
        if (element == null) {
            return null;
        }
        for (sibling = element.getPrevSibling(); sibling != null && !aClass.isInstance(sibling); sibling = sibling.getPrevSibling()) {
            for (Class<? extends PsiElement> stopClass : stopAt) {
                if (!stopClass.isInstance(sibling)) continue;
                return null;
            }
        }
        return (T)sibling;
    }

    private static void extractIfComments(PsiElement element, SwitchUtils.IfStatementBranch out) {
        PsiComment comment = ReplaceIfWithSwitchIntention.getPrevSiblingOfType(element, PsiComment.class, PsiStatement.class);
        while (comment != null) {
            String whiteSpaceText;
            PsiElement sibling = comment.getPrevSibling();
            String commentText = sibling instanceof PsiWhiteSpace ? ((whiteSpaceText = sibling.getText()).startsWith("\n") ? whiteSpaceText.substring(1) + comment.getText() : comment.getText()) : comment.getText();
            out.addComment(commentText);
            comment = ReplaceIfWithSwitchIntention.getPrevSiblingOfType((PsiElement)comment, PsiComment.class, PsiStatement.class);
        }
    }

    private static void extractStatementComments(PsiElement element, SwitchUtils.IfStatementBranch out) {
        PsiComment comment = ReplaceIfWithSwitchIntention.getPrevSiblingOfType(element, PsiComment.class, PsiStatement.class, PsiKeyword.class);
        while (comment != null) {
            String whiteSpaceText;
            PsiElement sibling = comment.getPrevSibling();
            String commentText = sibling instanceof PsiWhiteSpace ? ((whiteSpaceText = sibling.getText()).startsWith("\n") ? whiteSpaceText.substring(1) + comment.getText() : comment.getText()) : comment.getText();
            out.addStatementComment(commentText);
            comment = ReplaceIfWithSwitchIntention.getPrevSiblingOfType((PsiElement)comment, PsiComment.class, PsiStatement.class, PsiKeyword.class);
        }
    }

    private static void termReplace(PsiElement target, PsiElement replace, StringBuilder stringToReplaceWith, StringBuilder out) {
        if (target.equals(replace)) {
            out.append((CharSequence)stringToReplaceWith);
        } else if (target.getChildren().length == 0) {
            out.append(target.getText());
        } else {
            PsiElement[] children;
            for (PsiElement child : children = target.getChildren()) {
                ReplaceIfWithSwitchIntention.termReplace(child, replace, stringToReplaceWith, out);
            }
        }
    }

    private static void extractCaseExpressions(PsiExpression expression, PsiExpression switchExpression, SwitchUtils.IfStatementBranch values) {
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression argument = arguments[0];
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (EquivalenceChecker.expressionsAreEquivalent(switchExpression, argument)) {
                values.addCaseExpression(qualifierExpression);
            } else {
                values.addCaseExpression(argument);
            }
        } else if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            PsiExpression[] operands = polyadicExpression.getOperands();
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.OROR.equals(tokenType)) {
                for (PsiExpression operand : operands) {
                    ReplaceIfWithSwitchIntention.extractCaseExpressions(operand, switchExpression, values);
                }
            } else if (JavaTokenType.EQEQ.equals(tokenType) && operands.length == 2) {
                PsiExpression lhs = operands[0];
                PsiExpression rhs = operands[1];
                if (EquivalenceChecker.expressionsAreEquivalent(switchExpression, rhs)) {
                    values.addCaseExpression(lhs);
                } else if (EquivalenceChecker.expressionsAreEquivalent(switchExpression, lhs)) {
                    values.addCaseExpression(rhs);
                }
            }
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression contents = parenthesizedExpression.getExpression();
            ReplaceIfWithSwitchIntention.extractCaseExpressions(contents, switchExpression, values);
        }
    }

    private static void dumpBranch(SwitchUtils.IfStatementBranch branch, boolean castToInt, boolean wrap, boolean renameBreaks, String breakLabelName, @NonNls StringBuilder switchStatementText) {
        ReplaceIfWithSwitchIntention.dumpComments(branch.getComments(), switchStatementText);
        if (branch.isElse()) {
            switchStatementText.append("default: ");
        } else {
            for (PsiExpression caseExpression : branch.getCaseExpressions()) {
                switchStatementText.append("case ").append(ReplaceIfWithSwitchIntention.getCaseLabelText(caseExpression, castToInt)).append(": ");
            }
        }
        ReplaceIfWithSwitchIntention.dumpComments(branch.getStatementComments(), switchStatementText);
        ReplaceIfWithSwitchIntention.dumpBody(branch.getStatement(), wrap, renameBreaks, breakLabelName, switchStatementText);
    }

    @NonNls
    private static String getCaseLabelText(PsiExpression expression, boolean castToInt) {
        PsiType type;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (expression instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)expression).resolve()) instanceof PsiEnumConstant) {
            PsiEnumConstant enumConstant = (PsiEnumConstant)target;
            return enumConstant.getName();
        }
        if (castToInt && !PsiType.INT.equals((Object)(type = expression.getType()))) {
            return "(int)" + expression.getText();
        }
        return expression.getText();
    }

    private static void dumpComments(List<String> comments, StringBuilder switchStatementText) {
        if (comments.isEmpty()) {
            return;
        }
        switchStatementText.append('\n');
        for (String comment : comments) {
            switchStatementText.append(comment).append('\n');
        }
    }

    private static void dumpBody(PsiStatement bodyStatement, boolean wrap, boolean renameBreaks, String breakLabelName, @NonNls StringBuilder switchStatementText) {
        if (wrap) {
            switchStatementText.append('{');
        }
        if (bodyStatement instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)bodyStatement).getCodeBlock();
            PsiElement[] children = codeBlock.getChildren();
            for (int i = 1; i < children.length - 1; ++i) {
                PsiElement child = children[i];
                ReplaceIfWithSwitchIntention.appendElement(child, renameBreaks, breakLabelName, switchStatementText);
            }
        } else {
            ReplaceIfWithSwitchIntention.appendElement((PsiElement)bodyStatement, renameBreaks, breakLabelName, switchStatementText);
        }
        if (ControlFlowUtils.statementMayCompleteNormally(bodyStatement)) {
            switchStatementText.append("break;");
        }
        if (wrap) {
            switchStatementText.append('}');
        }
    }

    private static void appendElement(PsiElement element, boolean renameBreakElements, String breakLabelString, @NonNls StringBuilder switchStatementText) {
        String text = element.getText();
        if (!renameBreakElements) {
            switchStatementText.append(text);
        } else if (element instanceof PsiBreakStatement) {
            PsiBreakStatement breakStatement = (PsiBreakStatement)element;
            PsiIdentifier identifier = breakStatement.getLabelIdentifier();
            if (identifier == null) {
                switchStatementText.append("break ").append(breakLabelString).append(';');
            } else {
                switchStatementText.append(text);
            }
        } else if (element instanceof PsiBlockStatement || element instanceof PsiCodeBlock || element instanceof PsiIfStatement) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                ReplaceIfWithSwitchIntention.appendElement(child, renameBreakElements, breakLabelString, switchStatementText);
            }
        } else {
            switchStatementText.append(text);
        }
        PsiElement lastChild = element.getLastChild();
        if (ReplaceIfWithSwitchIntention.isEndOfLineComment(lastChild)) {
            switchStatementText.append('\n');
        }
    }

    private static boolean isEndOfLineComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType);
    }
}

