/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.parenthesis;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.parenthesis.UnnecessaryParenthesesPredicate;
import org.jetbrains.annotations.NotNull;

public class RemoveUnnecessaryParenthesesIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        UnnecessaryParenthesesPredicate unnecessaryParenthesesPredicate = new UnnecessaryParenthesesPredicate();
        if (unnecessaryParenthesesPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/parenthesis/RemoveUnnecessaryParenthesesIntention", "getElementPredicate"));
        }
        return unnecessaryParenthesesPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/parenthesis/RemoveUnnecessaryParenthesesIntention", "processIntention"));
        }
        if (element instanceof PsiParameterList) {
            RemoveUnnecessaryParenthesesIntention.stripLambdaParameterParentheses((PsiParameterList)element);
            return;
        }
        PsiExpression expression = (PsiExpression)element;
        ParenthesesUtils.removeParentheses(expression, false);
    }

    public static void stripLambdaParameterParentheses(PsiParameterList element) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        String text = element.getParameters()[0].getName() + "->{}";
        PsiLambdaExpression expression = (PsiLambdaExpression)factory.createExpressionFromText(text, (PsiElement)element);
        element.replace((PsiElement)expression.getParameterList());
    }
}

