/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.OperatorAssignmentPredicate;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ReplaceOperatorAssignmentWithAssignmentIntention
extends MutablyNamedIntention {
    private static final Map<IElementType, IElementType> tokenMap = new HashMap<IElementType, IElementType>();

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        OperatorAssignmentPredicate operatorAssignmentPredicate = new OperatorAssignmentPredicate();
        if (operatorAssignmentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/opassign/ReplaceOperatorAssignmentWithAssignmentIntention", "getElementPredicate"));
        }
        return operatorAssignmentPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        String operator = sign.getText();
        return IntentionPowerPackBundle.message("replace.operator.assignment.with.assignment.intention.name", operator);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        IElementType signTokenType;
        IElementType newOperatorToken;
        int precedence2;
        PsiPolyadicExpression binaryExpression;
        int precedence1;
        String rhsText;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/opassign/ReplaceOperatorAssignmentWithAssignmentIntention", "processIntention"));
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        String operator = sign.getText();
        String newOperator = operator.substring(0, operator.length() - 1);
        String lhsText = lhs.getText();
        String string = rhsText = rhs == null ? "" : rhs.getText();
        boolean parentheses = rhs instanceof PsiPolyadicExpression ? (precedence1 = ParenthesesUtils.getPrecedenceForOperator((binaryExpression = (PsiPolyadicExpression)rhs).getOperationTokenType())) >= (precedence2 = ParenthesesUtils.getPrecedenceForOperator(newOperatorToken = tokenMap.get(signTokenType = sign.getTokenType()))) || !ParenthesesUtils.isCommutativeOperator(newOperatorToken) : false;
        String cast = ReplaceOperatorAssignmentWithAssignmentIntention.getCastString(lhs, rhs);
        StringBuilder newExpression = new StringBuilder(lhsText);
        newExpression.append('=').append(cast);
        if (!cast.isEmpty()) {
            newExpression.append('(');
        }
        newExpression.append(lhsText).append(newOperator);
        if (parentheses) {
            newExpression.append('(').append(rhsText).append(')');
        } else {
            newExpression.append(rhsText);
        }
        if (!cast.isEmpty()) {
            newExpression.append(')');
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, newExpression.toString());
    }

    private static String getCastString(PsiExpression lhs, PsiExpression rhs) {
        PsiType lType = lhs.getType();
        PsiType rType = rhs.getType();
        if (lType == null || rType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) || !TypeConversionUtil.areTypesConvertible((PsiType)lType, (PsiType)rType)) {
            return "";
        }
        return '(' + lType.getCanonicalText() + ')';
    }

    static {
        tokenMap.put(JavaTokenType.PLUSEQ, JavaTokenType.PLUS);
        tokenMap.put(JavaTokenType.MINUSEQ, JavaTokenType.MINUS);
        tokenMap.put(JavaTokenType.ASTERISKEQ, JavaTokenType.ASTERISK);
        tokenMap.put(JavaTokenType.DIVEQ, JavaTokenType.DIV);
        tokenMap.put(JavaTokenType.ANDEQ, JavaTokenType.AND);
        tokenMap.put(JavaTokenType.OREQ, JavaTokenType.OR);
        tokenMap.put(JavaTokenType.XOREQ, JavaTokenType.XOR);
        tokenMap.put(JavaTokenType.PERCEQ, JavaTokenType.PERC);
        tokenMap.put(JavaTokenType.LTLTEQ, JavaTokenType.LTLT);
        tokenMap.put(JavaTokenType.GTGTEQ, JavaTokenType.GTGT);
        tokenMap.put(JavaTokenType.GTGTGTEQ, JavaTokenType.GTGTGT);
    }
}

