/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.AssertEqualsWithLiteralPredicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssertEqualsWithAssertLiteralIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        String assertString;
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length == 2) {
            String argText = args[0].getText();
            assertString = ReplaceAssertEqualsWithAssertLiteralIntention.getAssertString(argText);
        } else {
            String argText = args[1].getText();
            assertString = ReplaceAssertEqualsWithAssertLiteralIntention.getAssertString(argText);
        }
        return IntentionPowerPackBundle.message("replace.assert.equals.with.assert.literal.intention.name", assertString);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        AssertEqualsWithLiteralPredicate assertEqualsWithLiteralPredicate = new AssertEqualsWithLiteralPredicate();
        if (assertEqualsWithLiteralPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/junit/ReplaceAssertEqualsWithAssertLiteralIntention", "getElementPredicate"));
        }
        return assertEqualsWithLiteralPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        String assertString;
        String actualArgumentText;
        PsiExpression otherArg;
        String argText;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/junit/ReplaceAssertEqualsWithAssertLiteralIntention", "processIntention"));
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression expression = call.getMethodExpression();
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length == 2) {
            argText = args[0].getText();
            otherArg = "true".equals(argText) || "false".equals(argText) || "null".equals(argText) ? args[1] : args[0];
            actualArgumentText = otherArg.getText();
            assertString = ReplaceAssertEqualsWithAssertLiteralIntention.getAssertString(argText);
        } else {
            argText = args[1].getText();
            otherArg = "true".equals(argText) || "false".equals(argText) || "null".equals(argText) ? args[2] : args[1];
            actualArgumentText = args[0].getText() + ", " + otherArg.getText();
            assertString = ReplaceAssertEqualsWithAssertLiteralIntention.getAssertString(argText);
        }
        PsiElement qualifier = expression.getQualifier();
        StringBuilder newExpression = new StringBuilder();
        if (qualifier == null) {
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
            if (containingMethod != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)containingMethod, (String)"org.junit.Test", (boolean)true) && !ImportUtils.addStaticImport("org.junit.Assert", assertString, element)) {
                newExpression.append("org.junit.Assert.");
            }
        } else {
            newExpression.append(qualifier.getText()).append('.');
        }
        newExpression.append(assertString).append('(').append(actualArgumentText).append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)call, newExpression.toString());
    }

    @NonNls
    private static String getAssertString(@NonNls String text) {
        if ("true".equals(text)) {
            return "assertTrue";
        }
        if ("false".equals(text)) {
            return "assertFalse";
        }
        return "assertNull";
    }
}

