/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.AssertTrueOrFalsePredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class FlipAssertLiteralIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String fromMethodName = methodExpression.getReferenceName();
        String toMethodName = "assertTrue".equals(fromMethodName) ? "assertFalse" : "assertTrue";
        return IntentionPowerPackBundle.message("flip.assert.literal.intention.name", fromMethodName, toMethodName);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        AssertTrueOrFalsePredicate assertTrueOrFalsePredicate = new AssertTrueOrFalsePredicate();
        if (assertTrueOrFalsePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/junit/FlipAssertLiteralIntention", "getElementPredicate"));
        }
        return assertTrueOrFalsePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/junit/FlipAssertLiteralIntention", "processIntention"));
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String fromMethodName = methodExpression.getReferenceName();
        String toMethodName = "assertTrue".equals(fromMethodName) ? "assertFalse" : "assertTrue";
        StringBuilder newCall = new StringBuilder();
        PsiElement qualifier = methodExpression.getQualifier();
        if (qualifier == null) {
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
            if (containingMethod != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)containingMethod, (String)"org.junit.Test", (boolean)true) && !ImportUtils.addStaticImport("org.junit.Assert", toMethodName, element)) {
                newCall.append("org.junit.Assert.");
            }
        } else {
            newCall.append(qualifier.getText()).append('.');
        }
        newCall.append(toMethodName).append('(');
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 1) {
            newCall.append(BoolUtils.getNegatedExpressionText(arguments[0]));
        } else {
            newCall.append(arguments[0].getText()).append(',');
            newCall.append(BoolUtils.getNegatedExpressionText(arguments[1]));
        }
        newCall.append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)call, newCall.toString());
    }
}

