/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.increment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.increment.ExtractIncrementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractIncrementIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        PsiJavaToken sign = element instanceof PsiPostfixExpression ? ((PsiPostfixExpression)element).getOperationSign() : ((PsiPrefixExpression)element).getOperationSign();
        String operator = sign.getText();
        return IntentionPowerPackBundle.message("extract.increment.intention.name", operator);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ExtractIncrementPredicate extractIncrementPredicate = new ExtractIncrementPredicate();
        if (extractIncrementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/increment/ExtractIncrementIntention", "getElementPredicate"));
        }
        return extractIncrementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        SearchScope useScope;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiExpression operand;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/increment/ExtractIncrementIntention", "processIntention"));
        }
        if (element instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
            operand = postfixExpression.getOperand();
        } else {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            operand = prefixExpression.getOperand();
        }
        if (operand == null) {
            return;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (statement == null) {
            return;
        }
        PsiElement parent = statement.getParent();
        if (parent == null) {
            return;
        }
        Project project = element.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String newStatementText = element.getText() + ';';
        String operandText = operand.getText();
        if (parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement) {
            StringBuilder text = new StringBuilder();
            text.append('{');
            String elementText = ExtractIncrementIntention.getElementText((PsiElement)statement, element, operandText);
            if (element instanceof PsiPostfixExpression) {
                text.append(elementText);
                text.append(newStatementText);
            } else {
                text.append(newStatementText);
                text.append(elementText);
            }
            text.append('}');
            PsiCodeBlock codeBlock = factory.createCodeBlockFromText(text.toString(), parent);
            statement.replace((PsiElement)codeBlock);
            return;
        }
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, element);
        if (statement instanceof PsiReturnStatement) {
            if (element instanceof PsiPostfixExpression) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                PsiExpression returnValue = returnStatement.getReturnValue();
                if (returnValue == null) {
                    return;
                }
                JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                String variableName = javaCodeStyleManager.suggestUniqueVariableName("result", (PsiElement)returnValue, true);
                PsiType type = returnValue.getType();
                if (type == null) {
                    return;
                }
                String newReturnValueText = ExtractIncrementIntention.getElementText((PsiElement)returnValue, element, operandText);
                String declarationStatementText = type.getCanonicalText() + ' ' + variableName + '=' + newReturnValueText + ';';
                PsiStatement declarationStatement = factory.createStatementFromText(declarationStatementText, (PsiElement)returnStatement);
                parent.addBefore((PsiElement)declarationStatement, (PsiElement)statement);
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
                PsiStatement newReturnStatement = factory.createStatementFromText("return " + variableName + ';', (PsiElement)returnStatement);
                returnStatement.replace((PsiElement)newReturnStatement);
                return;
            }
            parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
        } else if (statement instanceof PsiThrowStatement) {
            if (element instanceof PsiPostfixExpression) {
                PsiThrowStatement returnStatement = (PsiThrowStatement)statement;
                PsiExpression exception = returnStatement.getException();
                if (exception == null) {
                    return;
                }
                JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                String variableName = javaCodeStyleManager.suggestUniqueVariableName("e", (PsiElement)exception, true);
                PsiType type = exception.getType();
                if (type == null) {
                    return;
                }
                String newReturnValueText = ExtractIncrementIntention.getElementText((PsiElement)exception, element, operandText);
                String declarationStatementText = type.getCanonicalText() + ' ' + variableName + '=' + newReturnValueText + ';';
                PsiStatement declarationStatement = factory.createStatementFromText(declarationStatementText, (PsiElement)returnStatement);
                parent.addBefore((PsiElement)declarationStatement, (PsiElement)statement);
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
                PsiStatement newReturnStatement = factory.createStatementFromText("throw " + variableName + ';', (PsiElement)returnStatement);
                returnStatement.replace((PsiElement)newReturnStatement);
                return;
            }
            parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
        } else if (!(statement instanceof PsiForStatement)) {
            if (element instanceof PsiPostfixExpression) {
                parent.addAfter((PsiElement)newStatement, (PsiElement)statement);
            } else {
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
            }
        } else if (operand instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)operand).resolve()) != null && !new LocalSearchScope((PsiElement)statement).equals((Object)(useScope = target.getUseScope()))) {
            if (element instanceof PsiPostfixExpression) {
                parent.addAfter((PsiElement)newStatement, (PsiElement)statement);
            } else {
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
            }
        }
        if (statement instanceof PsiLoopStatement) {
            PsiLoopStatement loopStatement = (PsiLoopStatement)statement;
            PsiStatement body = loopStatement.getBody();
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                if (element instanceof PsiPostfixExpression) {
                    PsiElement firstElement = codeBlock.getFirstBodyElement();
                    codeBlock.addBefore((PsiElement)newStatement, firstElement);
                } else {
                    codeBlock.add((PsiElement)newStatement);
                }
            } else {
                StringBuilder blockText = new StringBuilder();
                blockText.append('{');
                if (element instanceof PsiPostfixExpression) {
                    blockText.append(newStatementText);
                    if (body != null) {
                        blockText.append(body.getText());
                    }
                } else {
                    if (body != null) {
                        blockText.append(body.getText());
                    }
                    blockText.append(newStatementText);
                }
                blockText.append('}');
                PsiStatement blockStatement = factory.createStatementFromText(blockText.toString(), (PsiElement)statement);
                if (body == null) {
                    loopStatement.add((PsiElement)blockStatement);
                } else {
                    body.replace((PsiElement)blockStatement);
                }
            }
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)element, operandText);
    }

    private static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/increment/ExtractIncrementIntention", "getElementText"));
        }
        StringBuilder out = new StringBuilder();
        ExtractIncrementIntention.getElementText(element, elementToReplace, replacement, out);
        return out.toString();
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/increment/ExtractIncrementIntention", "getElementText"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/siyeh/ipp/increment/ExtractIncrementIntention", "getElementText"));
        }
        if (element.equals(elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children) {
            ExtractIncrementIntention.getElementText(child, elementToReplace, replacement, out);
        }
    }
}

