/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.fqnames;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.fqnames.FullyQualifiedNamePredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReplaceFullyQualifiedNameWithImportIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        FullyQualifiedNamePredicate fullyQualifiedNamePredicate = new FullyQualifiedNamePredicate();
        if (fullyQualifiedNamePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/fqnames/ReplaceFullyQualifiedNameWithImportIntention", "getElementPredicate"));
        }
        return fullyQualifiedNamePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/fqnames/ReplaceFullyQualifiedNameWithImportIntention", "processIntention"));
        }
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)element;
        PsiElement target = reference.resolve();
        if (!(target instanceof PsiClass)) {
            PsiElement parent = reference.getParent();
            while (parent instanceof PsiJavaCodeReferenceElement && !((target = (reference = (PsiJavaCodeReferenceElement)parent).resolve()) instanceof PsiClass)) {
                parent = parent.getParent();
            }
        }
        if (!(target instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)target;
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        PsiJavaFile file = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiJavaFile.class);
        if (file == null) {
            return;
        }
        ImportUtils.addImportIfNeeded(aClass, (PsiElement)reference);
        String fullyQualifiedText = reference.getText();
        QualificationRemover qualificationRemover = new QualificationRemover(fullyQualifiedText);
        file.accept((PsiElementVisitor)qualificationRemover);
        Collection<PsiJavaCodeReferenceElement> shortenedElements = qualificationRemover.getShortenedElements();
        int elementCount = shortenedElements.size();
        String text = elementCount == 1 ? IntentionPowerPackBundle.message("1.fully.qualified.name.status.bar.escape.highlighting.message", new Object[0]) : IntentionPowerPackBundle.message("multiple.fully.qualified.names.status.bar.escape.highlighting.message", elementCount);
        HighlightUtil.highlightElements(shortenedElements, text);
    }

    private static class QualificationRemover
    extends JavaRecursiveElementWalkingVisitor {
        private final String fullyQualifiedText;
        private final List<PsiJavaCodeReferenceElement> shortenedElements = new ArrayList<PsiJavaCodeReferenceElement>();

        QualificationRemover(String fullyQualifiedText) {
            this.fullyQualifiedText = fullyQualifiedText;
        }

        public Collection<PsiJavaCodeReferenceElement> getShortenedElements() {
            return Collections.unmodifiableCollection(this.shortenedElements);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement parent = reference.getParent();
            if (parent instanceof PsiImportStatement) {
                return;
            }
            String text = reference.getText();
            if (!text.equals(this.fullyQualifiedText)) {
                return;
            }
            PsiElement qualifier = reference.getQualifier();
            if (qualifier == null) {
                return;
            }
            try {
                qualifier.delete();
            }
            catch (IncorrectOperationException e) {
                Class<?> aClass = ((Object)((Object)this)).getClass();
                String className = aClass.getName();
                Logger logger = Logger.getInstance((String)className);
                logger.error((Throwable)e);
            }
            this.shortenedElements.add(reference);
        }
    }
}

