/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.ForLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceForLoopWithWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ForLoopPredicate forLoopPredicate = new ForLoopPredicate();
        if (forLoopPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/forloop/ReplaceForLoopWithWhileLoopIntention", "getElementPredicate"));
        }
        return forLoopPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiCodeBlock newBody;
        PsiBlockStatement blockStatement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/forloop/ReplaceForLoopWithWhileLoopIntention", "processIntention"));
        }
        PsiForStatement forStatement = (PsiForStatement)element.getParent();
        if (forStatement == null) {
            return;
        }
        PsiStatement initialization = forStatement.getInitialization();
        if (initialization != null && !(initialization instanceof PsiEmptyStatement)) {
            PsiElement parent = forStatement.getParent();
            parent.addBefore((PsiElement)initialization, (PsiElement)forStatement);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", element);
        PsiExpression forCondition = forStatement.getCondition();
        PsiExpression whileCondition = whileStatement.getCondition();
        PsiStatement body = forStatement.getBody();
        if (forCondition != null) {
            assert (whileCondition != null);
            whileCondition.replace((PsiElement)forCondition);
        }
        if ((blockStatement = (PsiBlockStatement)whileStatement.getBody()) == null) {
            return;
        }
        if (body instanceof PsiBlockStatement) {
            PsiBlockStatement newWhileBody = (PsiBlockStatement)blockStatement.replace((PsiElement)body);
            newBody = newWhileBody.getCodeBlock();
        } else {
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            if (body != null && !(body instanceof PsiEmptyStatement)) {
                codeBlock.addAfter((PsiElement)body, codeBlock.getFirstChild());
            }
            newBody = codeBlock;
        }
        PsiStatement update = forStatement.getUpdate();
        if (update != null) {
            PsiStatement[] updateStatements;
            if (update instanceof PsiExpressionListStatement) {
                PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)update;
                PsiExpressionList expressionList = expressionListStatement.getExpressionList();
                PsiExpression[] expressions = expressionList.getExpressions();
                updateStatements = new PsiStatement[expressions.length];
                for (PsiExpression expression : expressions) {
                    PsiStatement updateStatement;
                    updateStatements[i] = updateStatement = factory.createStatementFromText(expression.getText() + ';', element);
                }
            } else {
                PsiStatement updateStatement = factory.createStatementFromText(update.getText() + ';', element);
                updateStatements = new PsiStatement[]{updateStatement};
            }
            newBody.accept((PsiElementVisitor)new UpdateInserter(whileStatement, updateStatements));
            for (PsiStatement updateStatement : updateStatements) {
                newBody.addBefore((PsiElement)updateStatement, newBody.getLastChild());
            }
        }
        forStatement.replace((PsiElement)whileStatement);
    }

    private static class UpdateInserter
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiWhileStatement whileStatement;
        private final PsiStatement[] updateStatements;

        private UpdateInserter(PsiWhileStatement whileStatement, PsiStatement[] updateStatements) {
            this.whileStatement = whileStatement;
            this.updateStatements = updateStatements;
        }

        public void visitContinueStatement(PsiContinueStatement statement) {
            PsiStatement continuedStatement = statement.findContinuedStatement();
            if (!this.whileStatement.equals(continuedStatement)) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent == null) {
                return;
            }
            for (PsiStatement updateStatement : this.updateStatements) {
                parent.addBefore((PsiElement)updateStatement, (PsiElement)statement);
            }
            super.visitContinueStatement(statement);
        }
    }
}

