/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.ConvertCatchToThrowsPredicate;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConvertCatchToThrowsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConvertCatchToThrowsPredicate convertCatchToThrowsPredicate = new ConvertCatchToThrowsPredicate();
        if (convertCatchToThrowsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/exceptions/ConvertCatchToThrowsIntention", "getElementPredicate"));
        }
        return convertCatchToThrowsPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/exceptions/ConvertCatchToThrowsIntention", "processIntention"));
        }
        PsiCatchSection catchSection = (PsiCatchSection)element.getParent();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)catchSection, PsiMethod.class);
        if (method == null) {
            return;
        }
        PsiReferenceList throwsList = method.getThrowsList();
        PsiType catchType = catchSection.getCatchType();
        ConvertCatchToThrowsIntention.addToThrowsList(throwsList, catchType);
        PsiTryStatement tryStatement = catchSection.getTryStatement();
        PsiCatchSection[] catchSections = tryStatement.getCatchSections();
        if (catchSections.length > 1 || tryStatement.getResourceList() != null) {
            catchSection.delete();
        } else {
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            PsiElement first = tryBlock.getFirstBodyElement();
            PsiElement last = tryBlock.getLastBodyElement();
            if (first != null && last != null) {
                tryStatement.getParent().addRangeAfter(first, last, (PsiElement)tryStatement);
            }
            tryStatement.delete();
        }
    }

    private static void addToThrowsList(PsiReferenceList throwsList, PsiType catchType) {
        if (catchType instanceof PsiClassType) {
            PsiClassType[] types;
            PsiClassType classType = (PsiClassType)catchType;
            for (PsiClassType type : types = throwsList.getReferencedTypes()) {
                if (!catchType.equals(type)) continue;
                return;
            }
            Project project = throwsList.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
            throwsList.add((PsiElement)referenceElement);
        } else if (catchType instanceof PsiDisjunctionType) {
            PsiDisjunctionType disjunctionType = (PsiDisjunctionType)catchType;
            List disjunctions = disjunctionType.getDisjunctions();
            for (PsiType disjunction : disjunctions) {
                ConvertCatchToThrowsIntention.addToThrowsList(throwsList, disjunction);
            }
        }
    }
}

