/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.equality;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.equality.ObjectEqualityPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceEqualityWithEqualsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ObjectEqualityPredicate objectEqualityPredicate = new ObjectEqualityPredicate();
        if (objectEqualityPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/equality/ReplaceEqualityWithEqualsIntention", "getElementPredicate"));
        }
        return objectEqualityPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        PsiExpression lhs = exp.getLOperand();
        PsiExpression rhs = exp.getROperand();
        if (rhs == null) {
            return;
        }
        PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
        if (strippedLhs == null) {
            return;
        }
        PsiExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
        if (strippedRhs == null) {
            return;
        }
        IElementType tokenType = exp.getOperationTokenType();
        String expString = tokenType.equals(JavaTokenType.EQEQ) ? (ParenthesesUtils.getPrecedence(strippedLhs) > 1 ? '(' + strippedLhs.getText() + ").equals(" + strippedRhs.getText() + ')' : strippedLhs.getText() + ".equals(" + strippedRhs.getText() + ')') : (ParenthesesUtils.getPrecedence(strippedLhs) > 1 ? "!(" + strippedLhs.getText() + ").equals(" + strippedRhs.getText() + ')' : '!' + strippedLhs.getText() + ".equals(" + strippedRhs.getText() + ')');
        PsiReplacementUtil.replaceExpression((PsiExpression)exp, expString);
    }
}

