/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.braces;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBracesIntention
extends MutablyNamedIntention {
    @Override
    protected final String getTextForElement(PsiElement element) {
        PsiStatement body = BaseBracesIntention.getSurroundingStatement(element);
        if (body == null) {
            return null;
        }
        return IntentionPowerPackBundle.message(this.getMessageKey(), BaseBracesIntention.getKeyword(body.getParent(), (PsiElement)body));
    }

    @NotNull
    protected abstract String getMessageKey();

    @NotNull
    private static String getKeyword(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/braces/BaseBracesIntention", "getKeyword"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ipp/braces/BaseBracesIntention", "getKeyword"));
        }
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement elseBranch = ifStatement.getElseBranch();
            String string = element.equals(elseBranch) ? "else" : "if";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/braces/BaseBracesIntention", "getKeyword"));
            }
            return string;
        }
        PsiElement firstChild = parent.getFirstChild();
        assert (firstChild != null);
        String string = firstChild.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/braces/BaseBracesIntention", "getKeyword"));
        }
        return string;
    }

    @Nullable
    protected static PsiStatement getSurroundingStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/braces/BaseBracesIntention", "getSurroundingStatement"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            int offset = element.getTextOffset();
            if (thenBranch != null && offset > thenBranch.getTextOffset()) {
                PsiKeyword elseElement = ifStatement.getElseElement();
                if (elseElement == null || offset < elseElement.getTextOffset()) {
                    return null;
                }
                return ifStatement.getElseBranch();
            }
            return thenBranch;
        }
        if (parent instanceof PsiLoopStatement) {
            return ((PsiLoopStatement)parent).getBody();
        }
        return null;
    }
}

