/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.braces;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.braces.BaseBracesIntention;
import org.jetbrains.annotations.NotNull;

public class AddBracesIntention
extends BaseBracesIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiStatement statement = BaseBracesIntention.getSurroundingStatement(element);
                return statement != null && !(statement instanceof PsiBlockStatement);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/braces/AddBracesIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    @NotNull
    protected String getMessageKey() {
        if ("add.braces.intention.name" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/braces/AddBracesIntention", "getMessageKey"));
        }
        return "add.braces.intention.name";
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/braces/AddBracesIntention", "processIntention"));
        }
        PsiStatement statement = AddBracesIntention.getSurroundingStatement(element);
        if (statement == null) {
            return;
        }
        String newStatement = "{\n" + statement.getText() + "\n}";
        PsiReplacementUtil.replaceStatement(statement, newStatement);
    }
}

