/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.base;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.PsiElementEditorPredicate;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Intention
extends BaseElementAtCaretIntentionAction {
    private final PsiElementPredicate predicate = this.getElementPredicate();

    protected Intention() {
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/base/Intention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/siyeh/ipp/base/Intention", "invoke"));
        }
        if (this.prepareForWriting() && !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return;
        }
        PsiElement matchingElement = this.findMatchingElement(element, editor);
        if (matchingElement == null) {
            return;
        }
        this.processIntention(editor, matchingElement);
    }

    protected boolean prepareForWriting() {
        return true;
    }

    protected abstract void processIntention(@NotNull PsiElement var1);

    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ipp/base/Intention", "processIntention"));
        }
        this.processIntention(element);
    }

    @NotNull
    protected abstract PsiElementPredicate getElementPredicate();

    protected static void replaceExpressionWithNegatedExpression(@NotNull PsiExpression newExpression, @NotNull PsiExpression expression) {
        String expString;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/base/Intention", "replaceExpressionWithNegatedExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ipp/base/Intention", "replaceExpressionWithNegatedExpression"));
        }
        Project project = expression.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression expressionToReplace = expression;
        String newExpressionText = newExpression.getText();
        if (BoolUtils.isNegated(expression)) {
            expressionToReplace = BoolUtils.findNegation(expression);
            expString = newExpressionText;
        } else if (ComparisonUtils.isComparison(newExpression)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)newExpression;
            String negatedComparison = ComparisonUtils.getNegatedComparison(binaryExpression.getOperationTokenType());
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            expString = lhs.getText() + negatedComparison + rhs.getText();
        } else {
            expString = ParenthesesUtils.getPrecedence(newExpression) > 3 ? "!(" + newExpressionText + ')' : '!' + newExpressionText;
        }
        PsiExpression newCall = factory.createExpressionFromText(expString, (PsiElement)expression);
        assert (expressionToReplace != null);
        PsiElement insertedElement = expressionToReplace.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat(insertedElement);
    }

    protected static void replaceExpressionWithNegatedExpressionString(@NotNull String newExpression, @NotNull PsiExpression expression) {
        String expString;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/base/Intention", "replaceExpressionWithNegatedExpressionString"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ipp/base/Intention", "replaceExpressionWithNegatedExpressionString"));
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression expressionToReplace = expression;
        if (BoolUtils.isNegated(expression)) {
            expressionToReplace = BoolUtils.findNegation(expressionToReplace);
            expString = newExpression;
        } else {
            PsiElement parent = expressionToReplace.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                expressionToReplace = (PsiExpression)parent;
                parent = parent.getParent();
            }
            expString = "!(" + newExpression + ')';
        }
        PsiExpression newCall = factory.createExpressionFromText(expString, (PsiElement)expression);
        assert (expressionToReplace != null);
        PsiElement insertedElement = expressionToReplace.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat(insertedElement);
    }

    protected static void addStatementBefore(String newStatementText, PsiReturnStatement anchor) {
        Project project = anchor.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)anchor);
        PsiElement addedStatement = anchor.getParent().addBefore((PsiElement)newStatement, (PsiElement)anchor);
        CodeStyleManager.getInstance((Project)project).reformat(addedStatement);
    }

    @Nullable
    PsiElement findMatchingElement(@Nullable PsiElement element, Editor editor) {
        while (element != null && JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            if (this.predicate instanceof PsiElementEditorPredicate ? ((PsiElementEditorPredicate)this.predicate).satisfiedBy(element, editor) : this.predicate.satisfiedBy(element)) {
                return element;
            }
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/base/Intention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/siyeh/ipp/base/Intention", "isAvailable"));
        }
        return this.findMatchingElement(element, editor) != null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private String getPrefix() {
        Class<?> aClass = ((Object)((Object)this)).getClass();
        String name = aClass.getSimpleName();
        StringBuilder buffer = new StringBuilder(name.length() + 10);
        buffer.append(Character.toLowerCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buffer.append('.');
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @NotNull
    public String getText() {
        String string = IntentionPowerPackBundle.message(this.getPrefix() + ".name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/base/Intention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = IntentionPowerPackBundle.defaultableMessage(this.getPrefix() + ".family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/base/Intention", "getFamilyName"));
        }
        return string;
    }
}

