/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.asserttoif;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.asserttoif.IfStatementPredicate;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class IfToAssertionIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        IfStatementPredicate ifStatementPredicate = new IfStatementPredicate();
        if (ifStatementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/asserttoif/IfToAssertionIntention", "getElementPredicate"));
        }
        return ifStatementPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/asserttoif/IfToAssertionIntention", "processIntention"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)parent;
        PsiExpression condition = ifStatement.getCondition();
        StringBuilder newStatementText = new StringBuilder("assert ");
        newStatementText.append(BoolUtils.getNegatedExpressionText(condition));
        PsiStatement thenBranch = ifStatement.getThenBranch();
        String message = IfToAssertionIntention.getMessage((PsiElement)thenBranch);
        if (message != null) {
            newStatementText.append(':').append(message);
        }
        newStatementText.append(';');
        PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, newStatementText.toString());
    }

    private static String getMessage(PsiElement element) {
        if (element instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)element;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length != 1) {
                return null;
            }
            return IfToAssertionIntention.getMessage((PsiElement)statements[0]);
        }
        if (element instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)element;
            PsiExpression exception = ParenthesesUtils.stripParentheses(throwStatement.getException());
            if (!(exception instanceof PsiNewExpression)) {
                return null;
            }
            PsiNewExpression newExpression = (PsiNewExpression)exception;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return null;
            }
            return arguments[0].getText();
        }
        return null;
    }
}

