/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.annotation;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.annotation.AnnotateOverriddenMethodsPredicate;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotateOverriddenMethodsIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AnnotateOverriddenMethodsPredicate annotateOverriddenMethodsPredicate = new AnnotateOverriddenMethodsPredicate();
        if (annotateOverriddenMethodsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/annotation/AnnotateOverriddenMethodsIntention", "getElementPredicate"));
        }
        return annotateOverriddenMethodsPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAnnotation annotation = (PsiAnnotation)element;
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        String annotationName = ClassUtil.extractClassName((String)qualifiedName);
        PsiElement grandParent = element.getParent().getParent();
        if (grandParent instanceof PsiMethod) {
            return IntentionPowerPackBundle.message("annotate.overridden.methods.intention.method.name", annotationName);
        }
        return IntentionPowerPackBundle.message("annotate.overridden.methods.intention.parameters.name", annotationName);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethod method;
        int parameterIndex;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/annotation/AnnotateOverriddenMethodsIntention", "processIntention"));
        }
        PsiAnnotation annotation = (PsiAnnotation)element;
        String annotationName = annotation.getQualifiedName();
        if (annotationName == null) {
            return;
        }
        PsiElement parent = annotation.getParent();
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiMethod)) {
            if (!(grandParent instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)grandParent;
            PsiElement greatGrandParent = grandParent.getParent();
            if (!(greatGrandParent instanceof PsiParameterList)) {
                return;
            }
            PsiParameterList parameterList = (PsiParameterList)greatGrandParent;
            parameterIndex = parameterList.getParameterIndex(parameter);
            PsiElement greatGreatGrandParent = greatGrandParent.getParent();
            if (!(greatGreatGrandParent instanceof PsiMethod)) {
                return;
            }
            method = (PsiMethod)greatGreatGrandParent;
        } else {
            parameterIndex = -1;
            method = (PsiMethod)grandParent;
        }
        Project project = element.getProject();
        Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)true).findAll();
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        for (PsiMethod overridingMethod : overridingMethods) {
            if (parameterIndex == -1) {
                AnnotateOverriddenMethodsIntention.annotate((PsiModifierListOwner)overridingMethod, annotationName, attributes, element);
                continue;
            }
            PsiParameterList parameterList = overridingMethod.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter parameter = parameters[parameterIndex];
            AnnotateOverriddenMethodsIntention.annotate((PsiModifierListOwner)parameter, annotationName, attributes, element);
        }
    }

    private static void annotate(PsiModifierListOwner modifierListOwner, String annotationName, PsiNameValuePair[] attributes, PsiElement context) {
        Project project = context.getProject();
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (modifierList.findAnnotation(annotationName) != null) {
            return;
        }
        ExternalAnnotationsManager.AnnotationPlace annotationAnnotationPlace = annotationsManager.chooseAnnotationsPlace((PsiElement)modifierListOwner);
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NOWHERE) {
            return;
        }
        PsiFile fromFile = context.getContainingFile();
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL) {
            annotationsManager.annotateExternally(modifierListOwner, annotationName, fromFile, attributes);
        } else {
            PsiFile containingFile = modifierListOwner.getContainingFile();
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)containingFile)) {
                return;
            }
            PsiAnnotation inserted = modifierList.addAnnotation(annotationName);
            for (PsiNameValuePair pair : attributes) {
                inserted.setDeclaredAttributeValue(pair.getName(), pair.getValue());
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            codeStyleManager.shortenClassReferences((PsiElement)inserted);
            if (containingFile != fromFile) {
                UndoUtil.markPsiFileForUndo((PsiFile)fromFile);
            }
        }
    }
}

