/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.adapter;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.adapter.AdapterToListenerPredicate;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AdapterToListenerIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AdapterToListenerPredicate adapterToListenerPredicate = new AdapterToListenerPredicate();
        if (adapterToListenerPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/adapter/AdapterToListenerIntention", "getElementPredicate"));
        }
        return adapterToListenerPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String text = element.getText();
        return IntentionPowerPackBundle.message("adapter.to.listener.intention.name", text);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/adapter/AdapterToListenerIntention", "processIntention"));
        }
        PsiElement parent = element.getParent();
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)grandParent;
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (extendsList == null) {
            return;
        }
        PsiJavaCodeReferenceElement[] extendsReferences = extendsList.getReferenceElements();
        if (extendsReferences.length != 1) {
            return;
        }
        PsiJavaCodeReferenceElement extendsReference = extendsReferences[0];
        PsiElement target = extendsReference.resolve();
        if (!(target instanceof PsiClass)) {
            return;
        }
        PsiClass extendsClass = (PsiClass)target;
        PsiReferenceList implementsList = extendsClass.getImplementsList();
        if (implementsList == null) {
            return;
        }
        PsiJavaCodeReferenceElement[] implementsReferences = implementsList.getReferenceElements();
        ArrayList<PsiJavaCodeReferenceElement> listenerReferences = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiJavaCodeReferenceElement implementsReference : implementsReferences) {
            PsiMethod[] methods;
            PsiClass implementsClass;
            PsiElement implementsTarget;
            String name = implementsReference.getReferenceName();
            if (name != null && !name.endsWith("Listener") || !((implementsTarget = implementsReference.resolve()) instanceof PsiClass) || !(implementsClass = (PsiClass)implementsTarget).isInterface()) continue;
            for (PsiMethod method : methods = implementsClass.getMethods()) {
                PsiMethod[] superMethods;
                PsiMethod overridingMethod = aClass.findMethodBySignature(method, false);
                if (overridingMethod == null) {
                    AdapterToListenerIntention.implementMethodInClass(method, aClass);
                    continue;
                }
                for (PsiMethod superMethod : superMethods = overridingMethod.findSuperMethods(implementsClass)) {
                    if (!superMethod.equals(method)) continue;
                    AdapterToListenerIntention.removeCallsToSuperMethodFromMethod(overridingMethod, extendsClass);
                }
            }
            listenerReferences.add(implementsReference);
        }
        extendsReference.delete();
        PsiReferenceList referenceList = aClass.getImplementsList();
        if (referenceList != null) {
            for (PsiJavaCodeReferenceElement listenerReference : listenerReferences) {
                referenceList.add((PsiElement)listenerReference);
            }
        }
    }

    private static void removeCallsToSuperMethodFromMethod(@NotNull PsiMethod overridingMethod, @NotNull PsiClass superClass) {
        PsiStatement[] statements;
        if (overridingMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/adapter/AdapterToListenerIntention", "removeCallsToSuperMethodFromMethod"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ipp/adapter/AdapterToListenerIntention", "removeCallsToSuperMethodFromMethod"));
        }
        PsiCodeBlock body = overridingMethod.getBody();
        if (body == null) {
            return;
        }
        for (PsiStatement statement : statements = body.getStatements()) {
            PsiClass containingClass;
            PsiMethod targetMethod;
            PsiMethodCallExpression methodCallExpression;
            PsiReferenceExpression methodExpression;
            PsiExpression qualifier;
            PsiExpressionStatement expressionStatement;
            PsiExpression expression;
            if (!(statement instanceof PsiExpressionStatement) || !((expression = (expressionStatement = (PsiExpressionStatement)statement).getExpression()) instanceof PsiMethodCallExpression) || !((qualifier = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)expression).getMethodExpression()).getQualifierExpression()) instanceof PsiSuperExpression) || (targetMethod = methodCallExpression.resolveMethod()) == null || !superClass.equals(containingClass = targetMethod.getContainingClass())) continue;
            statement.delete();
        }
    }

    private static void implementMethodInClass(@NotNull PsiMethod method, @NotNull PsiClass aClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/adapter/AdapterToListenerIntention", "implementMethodInClass"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ipp/adapter/AdapterToListenerIntention", "implementMethodInClass"));
        }
        PsiMethod newMethod = (PsiMethod)aClass.add((PsiElement)method);
        PsiDocComment comment = newMethod.getDocComment();
        if (comment != null) {
            comment.delete();
        }
        PsiModifierList modifierList = newMethod.getModifierList();
        modifierList.setModifierProperty("abstract", false);
        Project project = aClass.getProject();
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        if (codeStyleSettings.INSERT_OVERRIDE_ANNOTATION && PsiUtil.isLanguageLevel6OrHigher((PsiElement)aClass)) {
            modifierList.addAnnotation("java.lang.Override");
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiCodeBlock codeBlock = factory.createCodeBlock();
        newMethod.add((PsiElement)codeBlock);
    }
}

