/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MethodOverridesStaticMethodInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("MethodOverridesStaticMethodOfSuperclass" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/MethodOverridesStaticMethodInspectionBase", "getID"));
        }
        return "MethodOverridesStaticMethodOfSuperclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.overrides.static.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/MethodOverridesStaticMethodInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.overrides.static.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/MethodOverridesStaticMethodInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverridesStaticMethodVisitor();
    }

    private static class MethodOverridesStaticMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverridesStaticMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/visibility/MethodOverridesStaticMethodInspectionBase$MethodOverridesStaticMethodVisitor", "visitMethod"));
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            String methodName = method.getName();
            MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                PsiMethod[] methods;
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                for (PsiMethod testMethod : methods = ancestorClass.findMethodsByName(methodName, false)) {
                    MethodSignature testSignature = testMethod.getSignature(PsiSubstitutor.EMPTY);
                    if (!signature.equals(testSignature) || !testMethod.hasModifierProperty("static") || testMethod.hasModifierProperty("private")) continue;
                    this.registerMethodError(method, new Object[0]);
                    return;
                }
            }
        }
    }
}

