/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaParameterHidingMemberVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;

    @NotNull
    public String getID() {
        if ("LambdaParameterHidesMemberVariable" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspectionBase", "getID"));
        }
        return "LambdaParameterHidesMemberVariable";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.problem.descriptor", aClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.superclass.option", new Object[0]), "m_ignoreInvisibleFields");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaParameterHidingMemberVariableVisitor();
    }

    private class LambdaParameterHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LambdaParameterHidingMemberVariableVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspectionBase$LambdaParameterHidingMemberVariableVisitor", "visitParameter"));
            }
            super.visitParameter(variable);
            PsiElement declarationScope = variable.getDeclarationScope();
            if (!(declarationScope instanceof PsiLambdaExpression)) {
                return;
            }
            PsiClass aClass = this.checkFieldName((PsiVariable)variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        @Nullable
        private PsiClass checkFieldName(PsiVariable variable) {
            String variableName = variable.getName();
            if (variableName == null) {
                return null;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)variable);
            while (aClass != null) {
                PsiField[] fields;
                for (PsiField field : fields = aClass.getAllFields()) {
                    String fieldName = field.getName();
                    if (!variableName.equals(fieldName) || LambdaParameterHidingMemberVariableInspectionBase.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(field, aClass)) continue;
                    return aClass;
                }
                aClass = ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return null;
        }
    }
}

