/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ClassEscapesItsScopeInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ClassEscapesDefinedScope" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "getID"));
        }
        return "ClassEscapesDefinedScope";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.escapes.defined.scope.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.escapes.defined.scope.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassEscapesItsScopeVisitor();
    }

    private static class ClassEscapesItsScopeVisitor
    extends BaseInspectionVisitor {
        private ClassEscapesItsScopeVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$ClassEscapesItsScopeVisitor", "visitMethod"));
            }
            if (method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("private")) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiType componentType = returnType.getDeepComponentType();
            if (!(componentType instanceof PsiClassType)) {
                return;
            }
            PsiClass returnClass = ((PsiClassType)componentType).resolve();
            if (returnClass == null) {
                return;
            }
            if (returnClass.getParent() instanceof PsiTypeParameterList) {
                return;
            }
            if (!ClassEscapesItsScopeVisitor.isLessRestrictiveScope(method, returnClass)) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement baseTypeElement = typeElement.getInnermostComponentReferenceElement();
            if (baseTypeElement == null) {
                return;
            }
            this.registerError((PsiElement)baseTypeElement, new Object[0]);
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$ClassEscapesItsScopeVisitor", "visitField"));
            }
            if (field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("private")) {
                return;
            }
            PsiType type = field.getType();
            PsiType componentType = type.getDeepComponentType();
            if (!(componentType instanceof PsiClassType)) {
                return;
            }
            PsiClass fieldClass = ((PsiClassType)componentType).resolve();
            if (fieldClass == null) {
                return;
            }
            if (!ClassEscapesItsScopeVisitor.fieldHasLessRestrictiveScope(field, fieldClass)) {
                return;
            }
            PsiTypeElement typeElement = field.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement baseTypeElement = typeElement.getInnermostComponentReferenceElement();
            if (baseTypeElement == null) {
                return;
            }
            this.registerError((PsiElement)baseTypeElement, new Object[0]);
        }

        private static boolean isLessRestrictiveScope(PsiMethod method, PsiClass aClass) {
            PsiMethod[] superMethods;
            int methodScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)method);
            int classScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)aClass);
            PsiClass containingClass = method.getContainingClass();
            int containingClassScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)containingClass);
            if (methodScopeOrder <= classScopeOrder || containingClassScopeOrder <= classScopeOrder) {
                return false;
            }
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                if (ClassEscapesItsScopeVisitor.isLessRestrictiveScope(superMethod, aClass)) continue;
                return false;
            }
            return true;
        }

        private static boolean fieldHasLessRestrictiveScope(PsiField field, PsiClass aClass) {
            int fieldScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)field);
            PsiClass containingClass = field.getContainingClass();
            int containingClassScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)containingClass);
            int classScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)aClass);
            return fieldScopeOrder > classScopeOrder && containingClassScopeOrder > classScopeOrder;
        }

        private static int getScopeOrder(PsiModifierListOwner element) {
            if (element.hasModifierProperty("public")) {
                return 4;
            }
            if (element.hasModifierProperty("private")) {
                return 1;
            }
            if (element.hasModifierProperty("protected")) {
                return 2;
            }
            return 3;
        }
    }
}

