/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class VolatileArrayFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("volatile.array.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/VolatileArrayFieldInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String typeString = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("volatile.field.problem.descriptor", typeString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/VolatileArrayFieldInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VolatileArrayFieldVisitor();
    }

    private static class VolatileArrayFieldVisitor
    extends BaseInspectionVisitor {
        private VolatileArrayFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/threading/VolatileArrayFieldInspection$VolatileArrayFieldVisitor", "visitField"));
            }
            super.visitField(field);
            if (!field.hasModifierProperty("volatile")) {
                return;
            }
            PsiType type = field.getType();
            if (type.getArrayDimensions() == 0) {
                return;
            }
            this.registerFieldError(field, type);
        }
    }
}

