/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UnconditionalWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unconditional.wait.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/UnconditionalWaitInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unconditional.wait.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/UnconditionalWaitInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnconditionalWaitVisitor();
    }

    private static class UnconditionalWaitVisitor
    extends BaseInspectionVisitor {
        private UnconditionalWaitVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/threading/UnconditionalWaitInspection$UnconditionalWaitVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                this.checkBody(body);
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/threading/UnconditionalWaitInspection$UnconditionalWaitVisitor", "visitSynchronizedStatement"));
            }
            super.visitSynchronizedStatement(statement);
            PsiCodeBlock body = statement.getBody();
            if (body != null) {
                this.checkBody(body);
            }
        }

        private void checkBody(PsiCodeBlock body) {
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return;
            }
            for (PsiStatement statement : statements) {
                PsiType parameterType;
                PsiParameterList parameterList;
                int numParams;
                PsiMethod method;
                PsiMethodCallExpression methodCallExpression;
                PsiReferenceExpression methodExpression;
                String methodName;
                PsiExpression firstExpression;
                if (UnconditionalWaitVisitor.isConditional(statement)) {
                    return;
                }
                if (!(statement instanceof PsiExpressionStatement) || !((firstExpression = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiMethodCallExpression) || !"wait".equals(methodName = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)firstExpression).getMethodExpression()).getReferenceName()) || (method = methodCallExpression.resolveMethod()) == null || (numParams = (parameterList = method.getParameterList()).getParametersCount()) > 2) continue;
                PsiParameter[] parameters = parameterList.getParameters();
                if (numParams > 0 && !(parameterType = parameters[0].getType()).equals(PsiType.LONG) || numParams > 1 && !(parameterType = parameters[1].getType()).equals(PsiType.INT)) continue;
                this.registerMethodCallError(methodCallExpression, new Object[0]);
            }
        }

        private static boolean isConditional(PsiStatement statement) {
            return statement instanceof PsiIfStatement;
        }
    }
}

