/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ThreadPriorityInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CallToThreadSetPriority" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadPriorityInspection", "getID"));
        }
        return "CallToThreadSetPriority";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.priority.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadPriorityInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.priority.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadPriorityInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadSetPriorityVisitor();
    }

    private static class ThreadSetPriorityVisitor
    extends BaseInspectionVisitor {
        private ThreadSetPriorityVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/threading/ThreadPriorityInspection$ThreadSetPriorityVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(methodCallExpression);
            if (!ThreadSetPriorityVisitor.isThreadSetPriority(methodCallExpression)) {
                return;
            }
            if (ThreadSetPriorityVisitor.hasNormalPriorityArgument(methodCallExpression)) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, new Object[0]);
        }

        private static boolean isThreadSetPriority(@NotNull PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/threading/ThreadPriorityInspection$ThreadSetPriorityVisitor", "isThreadSetPriority"));
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String setPriority = "setPriority";
            if (!"setPriority".equals(methodName)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            return "java.lang.Thread".equals(className);
        }

        private static boolean hasNormalPriorityArgument(@NotNull PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/threading/ThreadPriorityInspection$ThreadSetPriorityVisitor", "hasNormalPriorityArgument"));
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 1) {
                return false;
            }
            PsiExpression expression = expressions[0];
            if (!(expression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            String referenceName = referenceExpression.getReferenceName();
            String normPriority = "NORM_PRIORITY";
            if (!"NORM_PRIORITY".equals(referenceName)) {
                return false;
            }
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)element;
            PsiClass aClass = field.getContainingClass();
            String className = aClass.getQualifiedName();
            return "java.lang.Thread".equals(className);
        }
    }
}

