/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SynchronizeOnThisInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronize.on.this.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizeOnThisInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("synchronize.on.this.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizeOnThisInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnThisVisitor();
    }

    private static class SynchronizeOnThisVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnThisVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/threading/SynchronizeOnThisInspection$SynchronizeOnThisVisitor", "visitSynchronizedStatement"));
            }
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression = statement.getLockExpression();
            if (!(lockExpression instanceof PsiThisExpression)) {
                return;
            }
            this.registerError((PsiElement)lockExpression, new Object[0]);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/threading/SynchronizeOnThisInspection$SynchronizeOnThisVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                return;
            }
            if (!SynchronizeOnThisVisitor.isNotify(expression) && !SynchronizeOnThisVisitor.isWait(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isWait(PsiMethodCallExpression expression) {
            PsiType parameterType;
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"wait".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            int numParams = parameterList.getParametersCount();
            if (numParams > 2) {
                return false;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            if (numParams > 0 && !(parameterType = parameters[0].getType()).equals(PsiType.LONG)) {
                return false;
            }
            return numParams <= 1 || (parameterType = parameters[1].getType()).equals(PsiType.INT);
        }

        private static boolean isNotify(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"notify".equals(methodName) && !"notifyAll".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            return parameterList.getParametersCount() == 0;
        }
    }
}

