/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NestedSynchronizedStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.synchronized.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NestedSynchronizedStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.synchronized.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NestedSynchronizedStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedSynchronizedStatementVisitor();
    }

    private static class NestedSynchronizedStatementVisitor
    extends BaseInspectionVisitor {
        private NestedSynchronizedStatementVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/threading/NestedSynchronizedStatementInspection$NestedSynchronizedStatementVisitor", "visitSynchronizedStatement"));
            }
            super.visitSynchronizedStatement(statement);
            PsiElement containingSynchronizedStatement = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiSynchronizedStatement.class);
            if (containingSynchronizedStatement == null) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            PsiMethod containingContainingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)containingSynchronizedStatement, PsiMethod.class);
            if (containingMethod == null || containingContainingMethod == null || !containingMethod.equals(containingContainingMethod)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

