/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.telemetry;

import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.telemetry.InspectionGadgetsTelemetry;
import com.siyeh.ig.telemetry.InspectionRunTime;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class TelemetryDisplay {
    private final JScrollPane scrollPane;
    private final ListTableModel<InspectionRunTime> tableModel;

    public TelemetryDisplay(InspectionGadgetsTelemetry telemetry) {
        this.tableModel = new ListTableModel(TelemetryDisplay.createColumns(), telemetry.buildList(), 0);
        JBTable table = new JBTable(this.tableModel);
        new TableSpeedSearch((JTable)table);
        this.scrollPane = ScrollPaneFactory.createScrollPane((Component)table);
    }

    private static ColumnInfo[] createColumns() {
        final Comparator<InspectionRunTime> nameComparator = new Comparator<InspectionRunTime>(){

            @Override
            public int compare(InspectionRunTime runTime1, InspectionRunTime runTime2) {
                return runTime1.getInspectionName().compareToIgnoreCase(runTime2.getInspectionName());
            }
        };
        final Comparator<InspectionRunTime> runCountComparator = new Comparator<InspectionRunTime>(){

            @Override
            public int compare(InspectionRunTime runTime1, InspectionRunTime runTime2) {
                return runTime1.getRunCount() - runTime2.getRunCount();
            }
        };
        final Comparator<InspectionRunTime> totalRunTimeComparator = new Comparator<InspectionRunTime>(){

            @Override
            public int compare(InspectionRunTime runTime1, InspectionRunTime runTime2) {
                long totalRunTime2;
                long totalRunTime1 = runTime1.getTotalRunTime();
                if (totalRunTime1 < (totalRunTime2 = runTime2.getTotalRunTime())) {
                    return -1;
                }
                if (totalRunTime1 > totalRunTime2) {
                    return 1;
                }
                return 0;
            }
        };
        final Comparator<InspectionRunTime> averageRunTimeComparator = new Comparator<InspectionRunTime>(){

            @Override
            public int compare(InspectionRunTime runTime1, InspectionRunTime runTime2) {
                double averageRunTime2;
                double averageRunTime1 = runTime1.getAverageRunTime();
                if (averageRunTime1 < (averageRunTime2 = runTime2.getAverageRunTime())) {
                    return -1;
                }
                if (averageRunTime1 > averageRunTime2) {
                    return 1;
                }
                return 0;
            }
        };
        return new ColumnInfo[]{new ColumnInfo<InspectionRunTime, String>(InspectionGadgetsBundle.message("telemetry.table.column.inspection.name", new Object[0])){

            public String valueOf(InspectionRunTime inspectionRunTime) {
                return inspectionRunTime.getInspectionName();
            }

            public Comparator<InspectionRunTime> getComparator() {
                return nameComparator;
            }
        }, new ColumnInfo<InspectionRunTime, Integer>(InspectionGadgetsBundle.message("telemetry.table.column.run.count", new Object[0])){

            public Integer valueOf(InspectionRunTime inspectionRunTime) {
                return inspectionRunTime.getRunCount();
            }

            public Comparator<InspectionRunTime> getComparator() {
                return runCountComparator;
            }
        }, new ColumnInfo<InspectionRunTime, Long>(InspectionGadgetsBundle.message("telemetry.table.column.total.time", new Object[0])){

            public Long valueOf(InspectionRunTime inspectionRunTime) {
                return inspectionRunTime.getTotalRunTime();
            }

            public Comparator<InspectionRunTime> getComparator() {
                return totalRunTimeComparator;
            }
        }, new ColumnInfo<InspectionRunTime, String>(InspectionGadgetsBundle.message("telemetry.table.column.average.time", new Object[0])){
            private final NumberFormat format;
            {
                super(x0);
                this.format = NumberFormat.getNumberInstance();
                this.format.setMaximumFractionDigits(2);
                this.format.setMinimumFractionDigits(2);
            }

            public String valueOf(InspectionRunTime inspectionRunTime) {
                return this.format.format(inspectionRunTime.getAverageRunTime());
            }

            public Comparator<InspectionRunTime> getComparator() {
                return averageRunTimeComparator;
            }
        }};
    }

    public JComponent getContentPane() {
        return this.scrollPane;
    }

    public void update(List<InspectionRunTime> inspectionRunTimes) {
        this.tableModel.setItems(inspectionRunTimes);
    }
}

