/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnclearBinaryExpressionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unclear.binary.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unclear.binary.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnclearBinaryExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnclearBinaryExpressionVisitor();
    }

    static boolean mightBeConfusingExpression(@Nullable PsiElement element) {
        return element instanceof PsiPolyadicExpression || element instanceof PsiConditionalExpression || element instanceof PsiInstanceOfExpression || element instanceof PsiAssignmentExpression;
    }

    private static class UnclearBinaryExpressionVisitor
    extends BaseInspectionVisitor {
        private UnclearBinaryExpressionVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            PsiExpression[] operands;
            super.visitPolyadicExpression(expression);
            PsiElement parent = expression.getParent();
            if (UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent)) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            for (PsiExpression operand : operands = expression.getOperands()) {
                PsiPolyadicExpression polyadicExpression;
                IElementType childTokenType;
                if (operand instanceof PsiInstanceOfExpression) {
                    this.registerError((PsiElement)expression, new Object[0]);
                    return;
                }
                if (!(operand instanceof PsiPolyadicExpression) || tokenType.equals(childTokenType = (polyadicExpression = (PsiPolyadicExpression)operand).getOperationTokenType())) continue;
                this.registerError((PsiElement)expression, new Object[0]);
                return;
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            PsiElement parent = expression.getParent();
            if (UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent) || PsiUtilCore.hasErrorElementChild((PsiElement)expression)) {
                return;
            }
            PsiExpression condition = expression.getCondition();
            PsiExpression thenExpression = expression.getThenExpression();
            PsiExpression elseExpression = expression.getElseExpression();
            if (!(UnclearBinaryExpressionInspection.mightBeConfusingExpression((PsiElement)condition) || UnclearBinaryExpressionInspection.mightBeConfusingExpression((PsiElement)thenExpression) || UnclearBinaryExpressionInspection.mightBeConfusingExpression((PsiElement)elseExpression))) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            super.visitInstanceOfExpression(expression);
            PsiElement parent = expression.getParent();
            if (UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (!UnclearBinaryExpressionInspection.mightBeConfusingExpression((PsiElement)operand)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            IElementType tokenType;
            super.visitAssignmentExpression(expression);
            PsiElement parent = expression.getParent();
            if (UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent)) {
                return;
            }
            PsiExpression rhs = expression.getRExpression();
            if (!UnclearBinaryExpressionInspection.mightBeConfusingExpression((PsiElement)rhs)) {
                return;
            }
            if (!(rhs instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression nestedAssignment = (PsiAssignmentExpression)rhs;
            IElementType nestedTokenType = nestedAssignment.getOperationTokenType();
            if (nestedTokenType.equals(tokenType = expression.getOperationTokenType())) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class UnclearBinaryExpressionFix
    extends InspectionGadgetsFix {
        private UnclearBinaryExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection$UnclearBinaryExpressionFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unclear.binary.expression.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection$UnclearBinaryExpressionFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            StringBuilder newExpressionText = UnclearBinaryExpressionFix.createReplacementText(expression, new StringBuilder());
            PsiReplacementUtil.replaceExpression(expression, newExpressionText.toString());
        }

        private static StringBuilder createReplacementText(@Nullable PsiExpression expression, StringBuilder out) {
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression parentPolyadicExpression = (PsiPolyadicExpression)parent;
                    IElementType parentOperationSign = parentPolyadicExpression.getOperationTokenType();
                    boolean parentheses = !tokenType.equals(parentOperationSign);
                    UnclearBinaryExpressionFix.appendText(polyadicExpression, parentheses, out);
                } else {
                    boolean parentheses = parent instanceof PsiConditionalExpression || parent instanceof PsiInstanceOfExpression;
                    UnclearBinaryExpressionFix.appendText(polyadicExpression, parentheses, out);
                }
            } else if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression unwrappedExpression = parenthesizedExpression.getExpression();
                PsiElement parent = expression.getParent();
                if (!(parent instanceof PsiParenthesizedExpression)) {
                    out.append('(');
                    UnclearBinaryExpressionFix.createReplacementText(unwrappedExpression, out);
                    out.append(')');
                } else {
                    UnclearBinaryExpressionFix.createReplacementText(unwrappedExpression, out);
                }
            } else if (expression instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceofExpression = (PsiInstanceOfExpression)expression;
                PsiElement parent = expression.getParent();
                boolean parentheses = UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent);
                UnclearBinaryExpressionFix.appendText(instanceofExpression, parentheses, out);
            } else if (expression instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
                PsiElement parent = expression.getParent();
                boolean parentheses = UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent);
                UnclearBinaryExpressionFix.appendText(conditionalExpression, parentheses, out);
            } else if (expression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                PsiElement parent = expression.getParent();
                boolean parentheses = UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent) && !UnclearBinaryExpressionFix.isSimpleAssignment(assignmentExpression, parent);
                UnclearBinaryExpressionFix.appendText(assignmentExpression, parentheses, out);
            } else if (expression != null) {
                out.append(expression.getText());
            }
            return out;
        }

        private static boolean isSimpleAssignment(PsiAssignmentExpression assignmentExpression, PsiElement parent) {
            if (!(parent instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression parentAssignmentExpression = (PsiAssignmentExpression)parent;
            IElementType parentTokenType = parentAssignmentExpression.getOperationTokenType();
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            return parentTokenType.equals(tokenType);
        }

        private static void appendText(PsiAssignmentExpression assignmentExpression, boolean parentheses, StringBuilder out) {
            if (parentheses) {
                out.append('(');
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            out.append(lhs.getText());
            PsiJavaToken sign = assignmentExpression.getOperationSign();
            out.append(sign.getText());
            PsiExpression rhs = assignmentExpression.getRExpression();
            UnclearBinaryExpressionFix.createReplacementText(rhs, out);
            if (parentheses) {
                out.append(')');
            }
        }

        private static void appendText(PsiInstanceOfExpression instanceofExpression, boolean parentheses, @NonNls StringBuilder out) {
            if (parentheses) {
                out.append('(');
            }
            PsiExpression operand = instanceofExpression.getOperand();
            UnclearBinaryExpressionFix.createReplacementText(operand, out);
            out.append(" instanceof ");
            PsiTypeElement checkType = instanceofExpression.getCheckType();
            if (checkType != null) {
                out.append(checkType.getText());
            }
            if (parentheses) {
                out.append(')');
            }
        }

        private static void appendText(PsiConditionalExpression conditionalExpression, boolean parentheses, StringBuilder out) {
            if (parentheses) {
                out.append('(');
            }
            PsiExpression condition = conditionalExpression.getCondition();
            UnclearBinaryExpressionFix.createReplacementText(condition, out);
            out.append('?');
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            UnclearBinaryExpressionFix.createReplacementText(thenExpression, out);
            out.append(':');
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            UnclearBinaryExpressionFix.createReplacementText(elseExpression, out);
            if (parentheses) {
                out.append(')');
            }
        }

        private static void appendText(PsiPolyadicExpression polyadicExpression, boolean parentheses, StringBuilder out) {
            PsiExpression[] operands;
            if (parentheses) {
                out.append('(');
            }
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                PsiJavaToken token;
                if (operand == null) continue;
                if (operand.getType() == PsiType.VOID) {
                    throw new ProcessCanceledException();
                }
                if (operands.length == 1) {
                    UnclearBinaryExpressionFix.createReplacementText(operand, out);
                }
                if ((token = polyadicExpression.getTokenBeforeOperand(operand)) != null) {
                    PsiElement beforeToken = token.getPrevSibling();
                    if (beforeToken instanceof PsiWhiteSpace) {
                        out.append(beforeToken.getText());
                    }
                    out.append(token.getText());
                    PsiElement afterToken = token.getNextSibling();
                    if (afterToken instanceof PsiWhiteSpace) {
                        out.append(afterToken.getText());
                    }
                }
                if (operands.length == 1) continue;
                UnclearBinaryExpressionFix.createReplacementText(operand, out);
            }
            if (parentheses) {
                out.append(')');
            }
        }
    }
}

