/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RedundantImplementsInspection
extends BaseInspection {
    public boolean ignoreSerializable = false;
    public boolean ignoreCloneable = false;

    @NotNull
    public String getID() {
        if ("RedundantInterfaceDeclaration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantImplementsInspection", "getID"));
        }
        return "RedundantInterfaceDeclaration";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.implements.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantImplementsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.implements.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantImplementsInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel checkboxOptionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("ignore.serializable.option", new Object[0]), "ignoreSerializable");
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("ignore.cloneable.option", new Object[0]), "ignoreCloneable");
        return checkboxOptionsPanel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantImplementsFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantImplementsVisitor();
    }

    private class RedundantImplementsVisitor
    extends BaseInspectionVisitor {
        private RedundantImplementsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/style/RedundantImplementsInspection$RedundantImplementsVisitor", "visitClass"));
            }
            if (aClass.isAnnotationType()) {
                return;
            }
            if (aClass.isInterface()) {
                this.checkInterface(aClass);
            } else {
                this.checkConcreteClass(aClass);
            }
        }

        private void checkInterface(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] extendsElements;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement extendsElement : extendsElements = extendsList.getReferenceElements()) {
                PsiElement referent = extendsElement.resolve();
                if (!(referent instanceof PsiClass)) continue;
                PsiClass extendedInterface = (PsiClass)referent;
                this.checkExtendedInterface(extendedInterface, extendsElement, extendsElements);
            }
        }

        private void checkConcreteClass(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] implementsElements;
            PsiReferenceList extendsList = aClass.getExtendsList();
            PsiReferenceList implementsList = aClass.getImplementsList();
            if (extendsList == null || implementsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] extendsElements = extendsList.getReferenceElements();
            for (PsiJavaCodeReferenceElement implementsElement : implementsElements = implementsList.getReferenceElements()) {
                PsiElement referent = implementsElement.resolve();
                if (!(referent instanceof PsiClass)) continue;
                PsiClass implementedClass = (PsiClass)referent;
                this.checkImplementedClass(implementedClass, implementsElement, extendsElements, implementsElements);
            }
        }

        private void checkImplementedClass(PsiClass implementedClass, PsiJavaCodeReferenceElement implementsElement, PsiJavaCodeReferenceElement[] extendsElements, PsiJavaCodeReferenceElement[] implementsElements) {
            String qualifiedName = implementedClass.getQualifiedName();
            if (RedundantImplementsInspection.this.ignoreSerializable && "java.io.Serializable".equals(qualifiedName)) {
                return;
            }
            if (RedundantImplementsInspection.this.ignoreCloneable && "java.lang.Cloneable".equals(qualifiedName)) {
                return;
            }
            for (PsiJavaCodeReferenceElement extendsElement : extendsElements) {
                PsiClass extendedClass;
                PsiElement extendsReferent = extendsElement.resolve();
                if (!(extendsReferent instanceof PsiClass) || !(extendedClass = (PsiClass)extendsReferent).isInheritor(implementedClass, true)) continue;
                this.registerError((PsiElement)implementsElement, new Object[0]);
                return;
            }
            for (PsiJavaCodeReferenceElement testImplementElement : implementsElements) {
                PsiClass testImplementedClass;
                PsiElement implementsReferent;
                if (testImplementElement.equals(implementsElement) || !((implementsReferent = testImplementElement.resolve()) instanceof PsiClass) || !(testImplementedClass = (PsiClass)implementsReferent).isInheritor(implementedClass, true)) continue;
                this.registerError((PsiElement)implementsElement, new Object[0]);
                return;
            }
        }

        private void checkExtendedInterface(PsiClass extendedInterface, PsiJavaCodeReferenceElement extendsElement, PsiJavaCodeReferenceElement[] extendsElements) {
            for (PsiJavaCodeReferenceElement testExtendsElement : extendsElements) {
                PsiClass testExtendedInterface;
                PsiElement implementsReferent;
                if (testExtendsElement.equals(extendsElement) || !((implementsReferent = testExtendsElement.resolve()) instanceof PsiClass) || !(testExtendedInterface = (PsiClass)implementsReferent).isInheritor(extendedInterface, true)) continue;
                this.registerError((PsiElement)extendsElement, new Object[0]);
                return;
            }
        }
    }

    private static class RedundantImplementsFix
    extends InspectionGadgetsFix {
        private RedundantImplementsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantImplementsInspection$RedundantImplementsFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("redundant.implements.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantImplementsInspection$RedundantImplementsFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement implementReference = descriptor.getPsiElement();
            RedundantImplementsFix.deleteElement(implementReference);
        }
    }
}

