/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class NestedMethodCallInspectionBase
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.method.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/NestedMethodCallInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.method.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/NestedMethodCallInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedMethodCallVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private class NestedMethodCallVisitor
    extends BaseInspectionVisitor {
        private NestedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiElement field;
            PsiMethodCallExpression outerExpression;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/style/NestedMethodCallInspectionBase$NestedMethodCallVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            for (outerExpression = expression; outerExpression != null && outerExpression.getParent() instanceof PsiExpression; outerExpression = (PsiExpression)outerExpression.getParent()) {
            }
            if (outerExpression == null) {
                return;
            }
            PsiElement parent = outerExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return;
            }
            if (ExpressionUtils.isConstructorInvocation(grandParent)) {
                return;
            }
            if (NestedMethodCallInspectionBase.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class)) != null) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

