/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NonStaticInnerClassInSecureContextInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.static.inner.class.in.secure.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/NonStaticInnerClassInSecureContextInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.static.inner.class.in.secure.context.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/NonStaticInnerClassInSecureContextInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonStaticInnerClassInSecureContextVisitor();
    }

    private static class NonStaticInnerClassInSecureContextVisitor
    extends BaseInspectionVisitor {
        private NonStaticInnerClassInSecureContextVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/security/NonStaticInnerClassInSecureContextInspection$NonStaticInnerClassInSecureContextVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!PsiUtil.isInnerClass((PsiClass)aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

