/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariablePassedAsArgumentVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean passed;

    public VariablePassedAsArgumentVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/VariablePassedAsArgumentVisitor", "<init>"));
        }
        this.passed = false;
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/VariablePassedAsArgumentVisitor", "visitElement"));
        }
        if (!this.passed) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        PsiExpression[] arguments;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/VariablePassedAsArgumentVisitor", "visitMethodCallExpression"));
        }
        if (this.passed) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiExpressionList argumentList = call.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
            this.passed = true;
            break;
        }
    }

    public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
        PsiExpression[] arguments;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/VariablePassedAsArgumentVisitor", "visitNewExpression"));
        }
        if (this.passed) {
            return;
        }
        super.visitNewExpression(newExpression);
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
            this.passed = true;
            break;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

