/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportUtils {
    private ImportUtils() {
    }

    public static void addImportIfNeeded(@NotNull PsiClass aClass, @NotNull PsiElement context) {
        String packageName;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/ImportUtils", "addImportIfNeeded"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/psiutils/ImportUtils", "addImportIfNeeded"));
        }
        PsiFile file = context.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiClass outerClass = aClass.getContainingClass();
        if (outerClass == null ? PsiTreeUtil.isAncestor((PsiElement)javaFile, (PsiElement)aClass, (boolean)true) : PsiTreeUtil.isAncestor((PsiElement)outerClass, (PsiElement)context, (boolean)true) && !PsiTreeUtil.isAncestor((PsiElement)outerClass.getModifierList(), (PsiElement)context, (boolean)true)) {
            return;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return;
        }
        String containingPackageName = javaFile.getPackageName();
        if (containingPackageName.equals(packageName = ClassUtil.extractPackageName((String)qualifiedName)) || importList.findSingleClassImportStatement(qualifiedName) != null) {
            return;
        }
        if (importList.findOnDemandImportStatement(packageName) != null && !ImportUtils.hasDefaultImportConflict(qualifiedName, javaFile) && !ImportUtils.hasOnDemandImportConflict(qualifiedName, javaFile)) {
            return;
        }
        Project project = importList.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        PsiImportStatement importStatement = elementFactory.createImportStatement(aClass);
        importList.add((PsiElement)importStatement);
    }

    private static boolean nameCanBeStaticallyImported(@NotNull String fqName, @NotNull String memberName, @NotNull PsiElement context) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/ImportUtils", "nameCanBeStaticallyImported"));
        }
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/psiutils/ImportUtils", "nameCanBeStaticallyImported"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/siyeh/ig/psiutils/ImportUtils", "nameCanBeStaticallyImported"));
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (containingClass == null) {
            return false;
        }
        if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)fqName)) {
            return true;
        }
        PsiField field = containingClass.findFieldByName(memberName, true);
        if (field != null) {
            return false;
        }
        PsiMethod[] methods = containingClass.findMethodsByName(memberName, true);
        if (methods.length > 0) {
            return false;
        }
        return !ImportUtils.hasOnDemandImportStaticConflict(fqName, memberName, context, true) && !ImportUtils.hasExactImportStaticConflict(fqName, memberName, context);
    }

    public static boolean nameCanBeImported(@NotNull String fqName, @NotNull PsiElement context) {
        PsiJavaFile file;
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/ImportUtils", "nameCanBeImported"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/psiutils/ImportUtils", "nameCanBeImported"));
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (containingClass != null) {
            PsiClass[] innerClasses;
            if (fqName.equals(containingClass.getQualifiedName())) {
                return true;
            }
            String shortName = ClassUtil.extractClassName((String)fqName);
            for (PsiClass innerClass : innerClasses = containingClass.getAllInnerClasses()) {
                String className;
                if (innerClass.hasModifierProperty("private") || innerClass.hasModifierProperty("packageLocal") && !ClassUtils.inSamePackage((PsiElement)innerClass, (PsiElement)containingClass) || !shortName.equals(className = innerClass.getName())) continue;
                return false;
            }
            PsiField field = containingClass.findFieldByName(shortName, false);
            if (field != null) {
                return false;
            }
            field = containingClass.findFieldByName(shortName, true);
            if (field != null && PsiUtil.isAccessible((Project)containingClass.getProject(), (PsiMember)field, (PsiElement)containingClass, null)) {
                return false;
            }
        }
        if ((file = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)context, PsiJavaFile.class)) == null) {
            return false;
        }
        if (ImportUtils.hasExactImportConflict(fqName, file)) {
            return false;
        }
        if (ImportUtils.hasOnDemandImportConflict(fqName, file, true)) {
            return false;
        }
        if (ImportUtils.containsConflictingReference((PsiFile)file, fqName)) {
            return false;
        }
        if (ImportUtils.containsConflictingClass(fqName, file)) {
            return false;
        }
        return !ImportUtils.containsConflictingClassName(fqName, file);
    }

    private static boolean containsConflictingClassName(String fqName, PsiJavaFile file) {
        PsiClass[] classes;
        int lastDotIndex = fqName.lastIndexOf(46);
        String shortName = fqName.substring(lastDotIndex + 1);
        for (PsiClass aClass : classes = file.getClasses()) {
            if (!shortName.equals(aClass.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExactImportConflict(String fqName, PsiJavaFile file) {
        PsiImportList imports = file.getImportList();
        if (imports == null) {
            return false;
        }
        PsiImportStatement[] importStatements = imports.getImportStatements();
        int lastDotIndex = fqName.lastIndexOf(46);
        String shortName = fqName.substring(lastDotIndex + 1);
        String dottedShortName = '.' + shortName;
        for (PsiImportStatement importStatement : importStatements) {
            if (importStatement.isOnDemand()) continue;
            String importName = importStatement.getQualifiedName();
            if (importName == null) {
                return false;
            }
            if (importName.equals(fqName) || !importName.endsWith(dottedShortName)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExactImportStaticConflict(String qualifierClass, String memberName, PsiElement context) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiFile file = context.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            String qualifierText;
            PsiElement qualifier;
            PsiJavaCodeReferenceElement importReference;
            String name;
            if (importStaticStatement.isOnDemand() || !memberName.equals(name = importStaticStatement.getReferenceName()) || (importReference = importStaticStatement.getImportReference()) == null || (qualifier = importReference.getQualifier()) == null || qualifierClass.equals(qualifierText = qualifier.getText())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOnDemandImportConflict(@NotNull String fqName, @NotNull PsiJavaFile file) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/ImportUtils", "hasOnDemandImportConflict"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/psiutils/ImportUtils", "hasOnDemandImportConflict"));
        }
        return ImportUtils.hasOnDemandImportConflict(fqName, file, false);
    }

    private static boolean hasOnDemandImportConflict(@NotNull String fqName, @NotNull PsiJavaFile file, boolean strict) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/ImportUtils", "hasOnDemandImportConflict"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/psiutils/ImportUtils", "hasOnDemandImportConflict"));
        }
        PsiImportList imports = file.getImportList();
        if (imports == null) {
            return false;
        }
        PsiImportStatement[] importStatements = imports.getImportStatements();
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        for (PsiImportStatement importStatement : importStatements) {
            PsiClass[] classes;
            PsiElement element;
            String packageText;
            PsiJavaCodeReferenceElement importReference;
            if (!importStatement.isOnDemand() || (importReference = importStatement.getImportReference()) == null || (packageText = importReference.getText()).equals(packageName) || !((element = importReference.resolve()) instanceof PsiPackage)) continue;
            PsiPackage aPackage = (PsiPackage)element;
            if (!strict && aPackage.containsClassNamed(shortName)) {
                return true;
            }
            for (PsiClass aClass : classes = aPackage.findClassByShortName(shortName, file.getResolveScope())) {
                String qualifiedClassName = aClass.getQualifiedName();
                if (qualifiedClassName == null || fqName.equals(qualifiedClassName)) continue;
                return ImportUtils.containsConflictingReference((PsiFile)file, qualifiedClassName);
            }
        }
        return ImportUtils.hasJavaLangImportConflict(fqName, file);
    }

    private static boolean hasOnDemandImportStaticConflict(String fqName, String memberName, PsiElement context) {
        return ImportUtils.hasOnDemandImportStaticConflict(fqName, memberName, context, false);
    }

    private static boolean hasOnDemandImportStaticConflict(String fqName, String memberName, PsiElement context, boolean strict) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiFile file = context.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            String name;
            PsiClass targetClass;
            if (!importStaticStatement.isOnDemand() || (targetClass = importStaticStatement.resolveTargetClass()) == null || fqName.equals(name = targetClass.getQualifiedName())) continue;
            PsiField field = targetClass.findFieldByName(memberName, true);
            if (field != null && (!strict || ImportUtils.memberReferenced((PsiMember)field, (PsiElement)javaFile))) {
                return true;
            }
            PsiMethod[] methods = targetClass.findMethodsByName(memberName, true);
            if (methods.length <= 0 || strict && !ImportUtils.membersReferenced((PsiMember[])methods, (PsiElement)javaFile)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDefaultImportConflict(String fqName, PsiJavaFile file) {
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        String filePackageName = file.getPackageName();
        if (filePackageName.equals(packageName)) {
            return false;
        }
        Project project = file.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiPackage filePackage = psiFacade.findPackage(filePackageName);
        if (filePackage == null) {
            return false;
        }
        return filePackage.containsClassNamed(shortName);
    }

    public static boolean hasJavaLangImportConflict(String fqName, PsiJavaFile file) {
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        if ("java.lang".equals(packageName)) {
            return false;
        }
        Project project = file.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiPackage javaLangPackage = psiFacade.findPackage("java.lang");
        if (javaLangPackage == null) {
            return false;
        }
        return javaLangPackage.containsClassNamed(shortName);
    }

    private static boolean containsConflictingClass(String fqName, PsiJavaFile file) {
        PsiClass[] classes;
        for (PsiClass aClass : classes = file.getClasses()) {
            if (!ImportUtils.containsConflictingInnerClass(fqName, aClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsConflictingInnerClass(String fqName, PsiClass aClass) {
        PsiClass[] classes;
        String shortName = ClassUtil.extractClassName((String)fqName);
        if (shortName.equals(aClass.getName()) && !fqName.equals(aClass.getQualifiedName())) {
            return true;
        }
        for (PsiClass innerClass : classes = aClass.getInnerClasses()) {
            if (!ImportUtils.containsConflictingInnerClass(fqName, innerClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean addStaticImport(@NotNull String qualifierClass, @NonNls @NotNull String memberName, @NotNull PsiElement context) {
        if (qualifierClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/ImportUtils", "addStaticImport"));
        }
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/psiutils/ImportUtils", "addStaticImport"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/siyeh/ig/psiutils/ImportUtils", "addStaticImport"));
        }
        if (!ImportUtils.nameCanBeStaticallyImported(qualifierClass, memberName, context)) {
            return false;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)qualifierClass)) {
            return true;
        }
        PsiFile psiFile = context.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        PsiImportStatementBase existingImportStatement = importList.findSingleImportStatement(memberName);
        if (existingImportStatement != null) {
            return false;
        }
        PsiImportStaticStatement onDemandImportStatement = ImportUtils.findOnDemandImportStaticStatement(importList, qualifierClass);
        if (onDemandImportStatement != null && !ImportUtils.hasOnDemandImportStaticConflict(qualifierClass, memberName, context)) {
            return true;
        }
        Project project = context.getProject();
        GlobalSearchScope scope = context.getResolveScope();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass aClass = psiFacade.findClass(qualifierClass, scope);
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        List<PsiImportStaticStatement> imports = ImportUtils.getMatchingImports(importList, qualifiedName);
        int onDemandCount = JavaCodeStyleSettingsFacade.getInstance((Project)project).getNamesCountToUseImportOnDemand();
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        if (imports.size() < onDemandCount) {
            importList.add((PsiElement)elementFactory.createImportStaticStatement(aClass, memberName));
        } else {
            for (PsiImportStaticStatement importStatement : imports) {
                importStatement.delete();
            }
            importList.add((PsiElement)elementFactory.createImportStaticStatement(aClass, "*"));
        }
        return true;
    }

    @Nullable
    private static PsiImportStaticStatement findOnDemandImportStaticStatement(PsiImportList importList, String qualifierClass) {
        PsiImportStaticStatement[] importStaticStatements;
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            String text;
            PsiJavaCodeReferenceElement importReference;
            if (!importStaticStatement.isOnDemand() || (importReference = importStaticStatement.getImportReference()) == null || !qualifierClass.equals(text = importReference.getText())) continue;
            return importStaticStatement;
        }
        return null;
    }

    private static List<PsiImportStaticStatement> getMatchingImports(@NotNull PsiImportList importList, @NotNull String className) {
        if (importList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/ImportUtils", "getMatchingImports"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/psiutils/ImportUtils", "getMatchingImports"));
        }
        ArrayList<PsiImportStaticStatement> imports = new ArrayList<PsiImportStaticStatement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !className.equals(psiClass.getQualifiedName())) continue;
            imports.add(staticStatement);
        }
        return imports;
    }

    public static boolean isStaticallyImported(@NotNull PsiMember member, @NotNull PsiElement context) {
        PsiClass importClass;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/ImportUtils", "isStaticallyImported"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/psiutils/ImportUtils", "isStaticallyImported"));
        }
        PsiClass memberClass = member.getContainingClass();
        if (memberClass == null) {
            return false;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
            return false;
        }
        PsiFile psiFile = context.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        String memberName = member.getName();
        if (memberName == null) {
            return false;
        }
        PsiImportStatementBase existingImportStatement = importList.findSingleImportStatement(memberName);
        if (existingImportStatement instanceof PsiImportStaticStatement && InheritanceUtil.isInheritorOrSelf((PsiClass)(importClass = ((PsiImportStaticStatement)existingImportStatement).resolveTargetClass()), (PsiClass)memberClass, (boolean)true)) {
            return true;
        }
        String memberClassName = memberClass.getQualifiedName();
        if (memberClassName == null) {
            return false;
        }
        PsiImportStaticStatement onDemandImportStatement = ImportUtils.findOnDemandImportStaticStatement(importList, memberClassName);
        return onDemandImportStatement != null && !ImportUtils.hasOnDemandImportStaticConflict(memberClassName, memberName, context);
    }

    private static boolean memberReferenced(PsiMember member, PsiElement context) {
        MemberReferenceVisitor visitor = new MemberReferenceVisitor(member);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isReferenceFound();
    }

    private static boolean membersReferenced(PsiMember[] members, PsiElement context) {
        MemberReferenceVisitor visitor = new MemberReferenceVisitor(members);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isReferenceFound();
    }

    public static boolean containsConflictingReference(PsiFile element, String fullyQualifiedName) {
        CachedValuesManager.getManager((Project)element.getProject());
        Map cachedValue = (Map)CachedValuesManager.getCachedValue((PsiElement)element, (CachedValueProvider)new CachedValueProvider<Map<String, Boolean>>(){

            @Nullable
            public CachedValueProvider.Result<Map<String, Boolean>> compute() {
                return new CachedValueProvider.Result(Collections.synchronizedMap(new HashMap()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        Boolean conflictingRef = (Boolean)cachedValue.get(fullyQualifiedName);
        if (conflictingRef != null) {
            return conflictingRef;
        }
        ConflictingClassReferenceVisitor visitor = new ConflictingClassReferenceVisitor(fullyQualifiedName);
        element.accept((PsiElementVisitor)visitor);
        conflictingRef = visitor.isConflictingReferenceFound();
        cachedValue.put(fullyQualifiedName, conflictingRef);
        return conflictingRef;
    }

    private static class ConflictingClassReferenceVisitor
    extends JavaRecursiveElementVisitor {
        private final String name;
        private final String fullyQualifiedName;
        private boolean referenceFound = false;

        private ConflictingClassReferenceVisitor(String fullyQualifiedName) {
            this.name = ClassUtil.extractClassName((String)fullyQualifiedName);
            this.fullyQualifiedName = fullyQualifiedName;
        }

        public void visitElement(PsiElement element) {
            if (this.referenceFound) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (this.referenceFound) {
                return;
            }
            super.visitReferenceElement(reference);
            if (reference.getQualifier() != null) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            String testClassName = aClass.getName();
            String testClassQualifiedName = aClass.getQualifiedName();
            if (testClassQualifiedName == null || testClassName == null || testClassQualifiedName.equals(this.fullyQualifiedName) || !testClassName.equals(this.name)) {
                return;
            }
            this.referenceFound = true;
        }

        public boolean isConflictingReferenceFound() {
            return this.referenceFound;
        }
    }

    private static class MemberReferenceVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiMember[] members;
        private boolean referenceFound = false;

        public MemberReferenceVisitor(PsiMember member) {
            this.members = new PsiMember[]{member};
        }

        public MemberReferenceVisitor(PsiMember[] members) {
            this.members = members;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (this.referenceFound) {
                return;
            }
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement target = reference.resolve();
            for (PsiMember member : this.members) {
                if (!member.equals(target)) continue;
                this.referenceFound = true;
                return;
            }
        }

        public boolean isReferenceFound() {
            return this.referenceFound;
        }
    }
}

