/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class HardcodedLineSeparatorsInspection
extends BaseInspection {
    private static final Pattern newlines = Pattern.compile("\\\\n|\\\\r|\\\\0{0,1}12|\\\\0{0,1}15");

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("hardcoded.line.separator.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/HardcodedLineSeparatorsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("HardcodedLineSeparator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/HardcodedLineSeparatorsInspection", "getID"));
        }
        return "HardcodedLineSeparator";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("hardcoded.line.separator.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/HardcodedLineSeparatorsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HardcodedLineSeparatorsVisitor();
    }

    private static class HardcodedLineSeparatorsVisitor
    extends BaseInspectionVisitor {
        private HardcodedLineSeparatorsVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/portability/HardcodedLineSeparatorsInspection$HardcodedLineSeparatorsVisitor", "visitLiteralExpression"));
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (type == null || !TypeUtils.isJavaLangString(type) && !type.equals(PsiType.CHAR)) {
                return;
            }
            String text = expression.getText();
            Matcher matcher = newlines.matcher(text);
            int end = 0;
            while (matcher.find(end)) {
                int start = matcher.start();
                end = matcher.end();
                this.registerErrorAtOffset((PsiElement)expression, start, end - start, new Object[0]);
            }
        }
    }
}

